/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.cef;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import org.graylog.plugins.cef.codec.CEFCodec;
import org.graylog.plugins.cef.input.CEFAmqpInput;
import org.graylog.plugins.cef.input.CEFKafkaInput;
import org.graylog.plugins.cef.input.CEFTCPInput;
import org.graylog.plugins.cef.input.CEFUDPInput;
import org.graylog.plugins.cef.pipelines.rules.CEFParserFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog2.plugin.PluginModule;

public class CEFInputModule
extends PluginModule {
    protected void configure() {
        this.addCodec("CEF", CEFCodec.class);
        this.addMessageInput(CEFUDPInput.class);
        this.addMessageInput(CEFTCPInput.class);
        this.addMessageInput(CEFAmqpInput.class);
        this.addMessageInput(CEFKafkaInput.class);
        this.addMessageProcessorFunction("parse_cef", CEFParserFunction.class);
    }

    private void addMessageProcessorFunction(String name, Class<? extends Function<?>> functionClass) {
        this.addMessageProcessorFunction(this.binder(), name, functionClass);
    }

    private MapBinder<String, Function<?>> processorFunctionBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Function<?>>(){});
    }

    private void addMessageProcessorFunction(Binder binder, String name, Class<? extends Function<?>> functionClass) {
        this.processorFunctionBinder(binder).addBinding((Object)name).to(functionClass);
    }
}

