/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.primitives.Longs;
import javax.annotation.Nullable;
import org.graylog.plugins.map.geoip.;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class IPinfoASN {
    @JsonProperty(value="name")
    @Nullable
    public abstract String name();

    @JsonProperty(value="route")
    @Nullable
    public abstract String route();

    @JsonProperty(value="type")
    @Nullable
    public abstract String type();

    @JsonProperty(value="asn")
    @Nullable
    public abstract String asn();

    @JsonProperty(value="asn_numeric")
    @Nullable
    @Memoized
    public Long asnNumeric() {
        if (this.asn() == null) {
            return null;
        }
        return Longs.tryParse((String)this.asn().replace("AS", ""));
    }

    @JsonProperty(value="domain")
    @Nullable
    public abstract String domain();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new .AutoValue_IPinfoASN.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="route")
        public abstract Builder route(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(String var1);

        @JsonProperty(value="asn")
        public abstract Builder asn(String var1);

        @JsonProperty(value="domain")
        public abstract Builder domain(String var1);

        public abstract IPinfoASN build();
    }
}

