/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.graylog.plugins.map.geoip.IPLocationDatabaseAdapter;
import org.graylog.plugins.map.geoip.IPinfoASN;
import org.graylog.plugins.map.geoip.IPinfoStandardLocation;

public class MaxMindIPLocationDatabaseAdapter
implements IPLocationDatabaseAdapter {
    private final DatabaseReader reader;

    public MaxMindIPLocationDatabaseAdapter(File databaseFile) throws IOException {
        this.reader = new DatabaseReader.Builder(databaseFile).build();
    }

    @Override
    public CityResponse maxMindCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.reader.city(ipAddress);
    }

    @Override
    public CountryResponse maxMindCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.reader.country(ipAddress);
    }

    @Override
    public AsnResponse maxMindASN(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.reader.asn(ipAddress);
    }

    @Override
    public IPinfoStandardLocation ipInfoStandardLocation(InetAddress ipAddress) throws IOException, AddressNotFoundException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public IPinfoASN ipInfoASN(InetAddress ipAddress) throws IOException, AddressNotFoundException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

