/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.geoip.GeoIpResolverEngine;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpProcessor
implements MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpProcessor.class);
    private final ClusterConfigService clusterConfigService;
    private final ScheduledExecutorService scheduler;
    private final MetricRegistry metricRegistry;
    private final AtomicReference<GeoIpResolverConfig> config;
    private final AtomicReference<GeoIpResolverEngine> filterEngine;

    @Inject
    public GeoIpProcessor(ClusterConfigService clusterConfigService, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, EventBus eventBus, MetricRegistry metricRegistry) {
        this.clusterConfigService = clusterConfigService;
        this.scheduler = scheduler;
        this.metricRegistry = metricRegistry;
        GeoIpResolverConfig config = clusterConfigService.getOrDefault(GeoIpResolverConfig.class, GeoIpResolverConfig.defaultConfig());
        this.config = new AtomicReference<GeoIpResolverConfig>(config);
        this.filterEngine = new AtomicReference<GeoIpResolverEngine>(new GeoIpResolverEngine(config, metricRegistry));
        eventBus.register((Object)this);
    }

    @Override
    public Messages process(Messages messages) {
        for (Message message : messages) {
            this.filterEngine.get().filter(message);
        }
        return messages;
    }

    @Subscribe
    public void updateConfig(ClusterConfigChangedEvent event) {
        if (!GeoIpResolverConfig.class.getCanonicalName().equals(event.type())) {
            return;
        }
        this.scheduler.schedule(this::reload, 0L, TimeUnit.SECONDS);
    }

    private void reload() {
        GeoIpResolverConfig newConfig = this.clusterConfigService.getOrDefault(GeoIpResolverConfig.class, GeoIpResolverConfig.defaultConfig());
        LOG.info("Updating GeoIP resolver engine - {}", (Object)newConfig);
        this.config.set(newConfig);
        this.filterEngine.set(new GeoIpResolverEngine(newConfig, this.metricRegistry));
    }

    public static class Descriptor
    implements MessageProcessor.Descriptor {
        @Override
        public String name() {
            return "GeoIP Resolver";
        }

        @Override
        public String className() {
            return GeoIpProcessor.class.getCanonicalName();
        }
    }
}

