/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.v5;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.util.List;
import org.graylog.plugins.netflow.flows.CorruptFlowPacketException;
import org.graylog.plugins.netflow.flows.InvalidFlowVersionException;
import org.graylog.plugins.netflow.utils.ByteBufUtils;
import org.graylog.plugins.netflow.v5.NetFlowV5Header;
import org.graylog.plugins.netflow.v5.NetFlowV5Packet;
import org.graylog.plugins.netflow.v5.NetFlowV5Record;

public class NetFlowV5Parser {
    private static final int HEADER_LENGTH = 24;
    private static final int RECORD_LENGTH = 48;

    public static NetFlowV5Packet parsePacket(ByteBuf bb) {
        int readableBytes = bb.readableBytes();
        NetFlowV5Header header = NetFlowV5Parser.parseHeader(bb.slice(bb.readerIndex(), 24));
        int packetLength = 24 + header.count() * 48;
        if (header.count() <= 0 || readableBytes < packetLength) {
            throw new CorruptFlowPacketException("Insufficient data (expected: " + packetLength + " bytes, actual: " + readableBytes + " bytes)");
        }
        ImmutableList.Builder records = ImmutableList.builder();
        int offset = 24;
        for (int i = 0; i < header.count(); ++i) {
            records.add((Object)NetFlowV5Parser.parseRecord(bb.slice(offset + bb.readerIndex(), 48)));
            offset += 48;
        }
        return NetFlowV5Packet.create(header, (List<NetFlowV5Record>)records.build(), offset);
    }

    private static NetFlowV5Header parseHeader(ByteBuf bb) {
        int version = bb.readUnsignedShort();
        if (version != 5) {
            throw new InvalidFlowVersionException(version);
        }
        int count = bb.readUnsignedShort();
        long sysUptime = bb.readUnsignedInt();
        long unixSecs = bb.readUnsignedInt();
        long unixNsecs = bb.readUnsignedInt();
        long flowSequence = bb.readUnsignedInt();
        short engineType = bb.readUnsignedByte();
        short engineId = bb.readUnsignedByte();
        short sampling = bb.readShort();
        int samplingMode = sampling >> 14 & 3;
        int samplingInterval = sampling & 0x3FFF;
        return NetFlowV5Header.create(version, count, sysUptime, unixSecs, unixNsecs, flowSequence, engineType, engineId, samplingMode, samplingInterval);
    }

    private static NetFlowV5Record parseRecord(ByteBuf bb) {
        InetAddress srcAddr = ByteBufUtils.readInetAddress(bb);
        InetAddress dstAddr = ByteBufUtils.readInetAddress(bb);
        InetAddress nextHop = ByteBufUtils.readInetAddress(bb);
        int inputIface = bb.readUnsignedShort();
        int outputIface = bb.readUnsignedShort();
        long packetCount = bb.readUnsignedInt();
        long octetCount = bb.readUnsignedInt();
        long first = bb.readUnsignedInt();
        long last = bb.readUnsignedInt();
        int srcPort = bb.readUnsignedShort();
        int dstPort = bb.readUnsignedShort();
        bb.readByte();
        short tcpFlags = bb.readUnsignedByte();
        short protocol = bb.readUnsignedByte();
        short tos = bb.readUnsignedByte();
        int srcAs = bb.readUnsignedShort();
        int dstAs = bb.readUnsignedShort();
        short srcMask = bb.readUnsignedByte();
        short dstMask = bb.readUnsignedByte();
        return NetFlowV5Record.create(srcAddr, dstAddr, nextHop, inputIface, outputIface, packetCount, octetCount, first, last, srcPort, dstPort, tcpFlags, protocol, tos, srcAs, dstAs, srcMask, dstMask);
    }
}

