/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.v9;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.netflow.flows.EmptyTemplateException;
import org.graylog.plugins.netflow.flows.InvalidFlowVersionException;
import org.graylog.plugins.netflow.v9.NetFlowV9BaseRecord;
import org.graylog.plugins.netflow.v9.NetFlowV9FieldDef;
import org.graylog.plugins.netflow.v9.NetFlowV9FieldType;
import org.graylog.plugins.netflow.v9.NetFlowV9FieldTypeRegistry;
import org.graylog.plugins.netflow.v9.NetFlowV9Header;
import org.graylog.plugins.netflow.v9.NetFlowV9OptionRecord;
import org.graylog.plugins.netflow.v9.NetFlowV9OptionTemplate;
import org.graylog.plugins.netflow.v9.NetFlowV9Packet;
import org.graylog.plugins.netflow.v9.NetFlowV9Record;
import org.graylog.plugins.netflow.v9.NetFlowV9ScopeDef;
import org.graylog.plugins.netflow.v9.NetFlowV9Template;
import org.graylog.plugins.netflow.v9.RawNetFlowV9Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetFlowV9Parser {
    private static final Logger LOG = LoggerFactory.getLogger(NetFlowV9Parser.class);

    public static NetFlowV9Packet parsePacket(ByteBuf bb, NetFlowV9FieldTypeRegistry typeRegistry) {
        return NetFlowV9Parser.parsePacket(bb, typeRegistry, Maps.newHashMap(), null);
    }

    public static NetFlowV9Packet parsePacket(ByteBuf bb, NetFlowV9FieldTypeRegistry typeRegistry, Map<Integer, NetFlowV9Template> cache, @Nullable NetFlowV9OptionTemplate optionTemplate) {
        int dataLength = bb.readableBytes();
        NetFlowV9Header header = NetFlowV9Parser.parseHeader(bb);
        ArrayList<NetFlowV9Template> allTemplates = new ArrayList<NetFlowV9Template>();
        NetFlowV9OptionTemplate optTemplate = optionTemplate;
        ArrayList<NetFlowV9BaseRecord> records = new ArrayList<NetFlowV9BaseRecord>();
        while (bb.isReadable()) {
            bb.markReaderIndex();
            int flowSetId = bb.readUnsignedShort();
            if (flowSetId == 0) {
                List<NetFlowV9Template> templates = NetFlowV9Parser.parseTemplates(bb, typeRegistry);
                allTemplates.addAll(templates);
                for (NetFlowV9Template t : templates) {
                    cache.put(t.templateId(), t);
                }
                continue;
            }
            if (flowSetId == 1) {
                optTemplate = NetFlowV9Parser.parseOptionTemplate(bb, typeRegistry);
                continue;
            }
            bb.resetReaderIndex();
            if (cache.isEmpty() && optTemplate == null) {
                throw new EmptyTemplateException("Unable to parse NetFlow 9 records without template. Discarding packet.");
            }
            records.addAll(NetFlowV9Parser.parseRecords(bb, cache, optionTemplate));
        }
        return NetFlowV9Packet.create(header, allTemplates, optTemplate, records, dataLength);
    }

    public static NetFlowV9Header parseHeader(ByteBuf bb) {
        int version = bb.readUnsignedShort();
        if (version != 9) {
            throw new InvalidFlowVersionException(version);
        }
        int count = bb.readUnsignedShort();
        long sysUptime = bb.readUnsignedInt();
        long unixSecs = bb.readUnsignedInt();
        long sequence = bb.readUnsignedInt();
        long sourceId = bb.readUnsignedInt();
        return NetFlowV9Header.create(version, count, sysUptime, unixSecs, sequence, sourceId);
    }

    public static List<NetFlowV9Template> parseTemplates(ByteBuf bb, NetFlowV9FieldTypeRegistry typeRegistry) {
        NetFlowV9Template template;
        ImmutableList.Builder templates = ImmutableList.builder();
        int len = bb.readUnsignedShort();
        for (int p = 4; p < len; p += 4 + template.fieldCount() * 4) {
            template = NetFlowV9Parser.parseTemplate(bb, typeRegistry);
            templates.add((Object)template);
        }
        return templates.build();
    }

    public static NetFlowV9Template parseTemplate(ByteBuf bb, NetFlowV9FieldTypeRegistry typeRegistry) {
        int templateId = bb.readUnsignedShort();
        int fieldCount = bb.readUnsignedShort();
        ImmutableList.Builder fieldDefs = ImmutableList.builder();
        for (int i = 0; i < fieldCount; ++i) {
            int fieldType = bb.readUnsignedShort();
            int fieldLength = bb.readUnsignedShort();
            NetFlowV9FieldType registeredType = typeRegistry.get(fieldType);
            NetFlowV9FieldType type = registeredType == null ? NetFlowV9FieldType.create(fieldType, NetFlowV9FieldType.ValueType.byLength(fieldLength), "field_" + fieldType) : registeredType;
            NetFlowV9FieldDef fieldDef = NetFlowV9FieldDef.create(type, fieldLength);
            fieldDefs.add((Object)fieldDef);
        }
        return NetFlowV9Template.create(templateId, fieldCount, (List<NetFlowV9FieldDef>)fieldDefs.build());
    }

    public static List<Map.Entry<Integer, byte[]>> parseTemplatesShallow(ByteBuf bb) {
        int fieldCount;
        ImmutableList.Builder templates = ImmutableList.builder();
        int len = bb.readUnsignedShort();
        for (int p = 4; p < len; p += 4 + fieldCount * 4) {
            int start = bb.readerIndex();
            int templateId = bb.readUnsignedShort();
            fieldCount = bb.readUnsignedShort();
            ImmutableList.Builder fieldDefs = ImmutableList.builder();
            for (int i = 0; i < fieldCount; ++i) {
                int fieldType = bb.readUnsignedShort();
                int n = bb.readUnsignedShort();
            }
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)bb, (int)start, (int)(bb.readerIndex() - start));
            Map.Entry template = Maps.immutableEntry((Object)templateId, (Object)bytes);
            templates.add((Object)template);
        }
        return templates.build();
    }

    public static NetFlowV9OptionTemplate parseOptionTemplate(ByteBuf bb, NetFlowV9FieldTypeRegistry typeRegistry) {
        int length = bb.readUnsignedShort();
        int templateId = bb.readUnsignedShort();
        int optionScopeLength = bb.readUnsignedShort();
        int optionLength = bb.readUnsignedShort();
        int p = bb.readerIndex();
        int endOfScope = p + optionScopeLength;
        int endOfOption = endOfScope + optionLength;
        int endOfTemplate = p - 10 + length;
        ImmutableList.Builder scopeDefs = ImmutableList.builder();
        while (bb.readerIndex() < endOfScope) {
            int scopeType = bb.readUnsignedShort();
            int scopeLength = bb.readUnsignedShort();
            scopeDefs.add((Object)NetFlowV9ScopeDef.create(scopeType, scopeLength));
        }
        bb.readerIndex(endOfScope);
        ImmutableList.Builder optionDefs = ImmutableList.builder();
        while (bb.readerIndex() < endOfOption) {
            int optType = bb.readUnsignedShort();
            int optLength = bb.readUnsignedShort();
            NetFlowV9FieldType t = typeRegistry.get(optType);
            if (t == null) {
                t = NetFlowV9FieldType.create(optType, NetFlowV9FieldType.ValueType.byLength(optLength), "option_" + optType);
            }
            optionDefs.add((Object)NetFlowV9FieldDef.create(t, optLength));
        }
        bb.readerIndex(endOfTemplate);
        return NetFlowV9OptionTemplate.create(templateId, (List<NetFlowV9ScopeDef>)scopeDefs.build(), (List<NetFlowV9FieldDef>)optionDefs.build());
    }

    public static Map.Entry<Integer, byte[]> parseOptionTemplateShallow(ByteBuf bb) {
        int n;
        int start = bb.readerIndex();
        int length = bb.readUnsignedShort();
        int templateId = bb.readUnsignedShort();
        int optionScopeLength = bb.readUnsignedShort();
        int optionLength = bb.readUnsignedShort();
        int p = bb.readerIndex();
        int endOfScope = p + optionScopeLength;
        int endOfOption = endOfScope + optionLength;
        int endOfTemplate = p - 10 + length;
        while (bb.readerIndex() < endOfScope) {
            int scopeType = bb.readUnsignedShort();
            n = bb.readUnsignedShort();
        }
        bb.readerIndex(endOfScope);
        while (bb.readerIndex() < endOfOption) {
            int optType = bb.readUnsignedShort();
            n = bb.readUnsignedShort();
        }
        bb.readerIndex(endOfTemplate);
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)bb, (int)start, (int)(bb.readerIndex() - start));
        return Maps.immutableEntry((Object)templateId, (Object)bytes);
    }

    public static List<NetFlowV9BaseRecord> parseRecords(ByteBuf bb, Map<Integer, NetFlowV9Template> cache, NetFlowV9OptionTemplate optionTemplate) {
        ImmutableList<NetFlowV9FieldDef> defs;
        boolean isOptionTemplate;
        ArrayList<NetFlowV9BaseRecord> records = new ArrayList<NetFlowV9BaseRecord>();
        int flowSetId = bb.readUnsignedShort();
        int length = bb.readUnsignedShort();
        int end = bb.readerIndex() - 4 + length;
        boolean bl = isOptionTemplate = optionTemplate != null && optionTemplate.templateId() == flowSetId;
        if (isOptionTemplate) {
            defs = optionTemplate.optionDefs();
        } else {
            NetFlowV9Template t = cache.get(flowSetId);
            if (t == null) {
                return Collections.emptyList();
            }
            defs = t.definitions();
        }
        int unitSize = 0;
        for (Object def : defs) {
            unitSize += ((NetFlowV9FieldDef)def).length();
        }
        while (bb.readerIndex() < end && bb.readableBytes() >= unitSize) {
            ImmutableMap.Builder fields = ImmutableMap.builder();
            for (NetFlowV9FieldDef def : defs) {
                String key = def.type().name().toLowerCase(Locale.ROOT);
                Optional<Object> optValue = def.parse(bb);
                optValue.ifPresent(value -> fields.put((Object)key, value));
            }
            if (isOptionTemplate) {
                ImmutableMap.Builder scopes = ImmutableMap.builder();
                for (NetFlowV9ScopeDef def : optionTemplate.scopeDefs()) {
                    int t = def.type();
                    int len = def.length();
                    long l = 0L;
                    for (int i = 0; i < len; ++i) {
                        l <<= 8;
                        l |= (long)bb.readUnsignedByte();
                    }
                    scopes.put((Object)t, (Object)l);
                }
                records.add(NetFlowV9OptionRecord.create((Map<String, Object>)fields.build(), (Map<Integer, Object>)scopes.build()));
            } else {
                records.add(NetFlowV9Record.create((Map<String, Object>)fields.build()));
            }
            if (end - bb.readerIndex() >= unitSize) continue;
            break;
        }
        bb.readerIndex(end);
        return records;
    }

    public static Integer parseRecordShallow(ByteBuf bb) {
        int start = bb.readerIndex();
        int usedTemplateId = bb.readUnsignedShort();
        int length = bb.readUnsignedShort();
        int end = bb.readerIndex() - 4 + length;
        bb.readerIndex(end);
        return usedTemplateId;
    }

    public static RawNetFlowV9Packet parsePacketShallow(ByteBuf bb) {
        ByteBuf buf = bb.duplicate();
        int dataLength = buf.readableBytes();
        NetFlowV9Header header = NetFlowV9Parser.parseHeader(buf);
        HashMap allTemplates = Maps.newHashMap();
        Map.Entry<Integer, byte[]> optTemplate = null;
        HashSet usedTemplates = Sets.newHashSet();
        while (buf.isReadable()) {
            buf.markReaderIndex();
            int flowSetId = buf.readUnsignedShort();
            if (flowSetId == 0) {
                List<Map.Entry<Integer, byte[]>> templates = NetFlowV9Parser.parseTemplatesShallow(buf);
                for (Map.Entry<Integer, byte[]> t : templates) {
                    allTemplates.put(t.getKey(), t.getValue());
                }
                continue;
            }
            if (flowSetId == 1) {
                optTemplate = NetFlowV9Parser.parseOptionTemplateShallow(buf);
                continue;
            }
            buf.resetReaderIndex();
            usedTemplates.add(NetFlowV9Parser.parseRecordShallow(buf));
        }
        return RawNetFlowV9Packet.create(header, dataLength, allTemplates, optTemplate, usedTemplates);
    }
}

