/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import java.util.Collections;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;

public class BooleanValuedFunctionWrapper
extends BaseExpression
implements LogicalExpression {
    private final Expression expr;

    public BooleanValuedFunctionWrapper(Token start, Expression expr) {
        super(start);
        this.expr = expr;
        if (!expr.getType().equals(Boolean.class)) {
            throw new IllegalArgumentException("expr must be of boolean type");
        }
    }

    @Override
    public boolean evaluateBool(EvaluationContext context) {
        Object value = this.expr.evaluateUnsafe(context);
        return value != null && (Boolean)value != false;
    }

    @Override
    public boolean isConstant() {
        return this.expr.isConstant();
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        return this.evaluateBool(context);
    }

    @Override
    public Class getType() {
        return this.expr.getType();
    }

    public Expression expression() {
        return this.expr;
    }

    public String toString() {
        return this.expr.toString();
    }

    @Override
    public Iterable<Expression> children() {
        return Collections.singleton(this.expr);
    }
}

