/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db;

import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.RuleMetricsConfigDto;
import org.graylog.plugins.pipelineprocessor.events.RuleMetricsConfigChangedEvent;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.cluster.ClusterConfigService;

public class RuleMetricsConfigService {
    private final ClusterConfigService clusterConfigService;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public RuleMetricsConfigService(ClusterConfigService clusterConfigService, ClusterEventBus clusterEventBus) {
        this.clusterConfigService = clusterConfigService;
        this.clusterEventBus = clusterEventBus;
    }

    public RuleMetricsConfigDto save(RuleMetricsConfigDto config) {
        this.clusterConfigService.write(config);
        this.clusterEventBus.post(RuleMetricsConfigChangedEvent.create(config.metricsEnabled()));
        return this.get();
    }

    public RuleMetricsConfigDto get() {
        return this.clusterConfigService.getOrDefault(RuleMetricsConfigDto.class, RuleMetricsConfigDto.createDefault());
    }
}

