/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.events.RulesChangedEvent;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbRuleService
implements RuleService {
    private static final Logger log = LoggerFactory.getLogger(MongoDbRuleService.class);
    private static final String COLLECTION = "pipeline_processor_rules";
    private final JacksonDBCollection<RuleDao, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbRuleService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION), RuleDao.class, String.class, (ObjectMapper)mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"title"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public RuleDao save(RuleDao rule) {
        WriteResult save = this.dbCollection.save((Object)rule);
        RuleDao savedRule = (RuleDao)save.getSavedObject();
        this.clusterBus.post(RulesChangedEvent.updatedRuleId(savedRule.id()));
        return savedRule;
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        RuleDao rule = (RuleDao)this.dbCollection.findOneById((Object)id);
        if (rule == null) {
            throw new NotFoundException("No rule with id " + id);
        }
        return rule;
    }

    @Override
    public RuleDao loadByName(String name) throws NotFoundException {
        DBQuery.Query query = DBQuery.is((String)"title", (Object)name);
        RuleDao rule = (RuleDao)this.dbCollection.findOne(query);
        if (rule == null) {
            throw new NotFoundException("No rule with name " + name);
        }
        return rule;
    }

    @Override
    public Collection<RuleDao> loadAll() {
        ImmutableSet immutableSet;
        block8: {
            DBCursor ruleDaos = this.dbCollection.find().sort((DBObject)DBSort.asc((String)"title"));
            Throwable throwable = null;
            try {
                immutableSet = ImmutableSet.copyOf((Iterable)ruleDaos);
                if (ruleDaos == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (ruleDaos != null) {
                            MongoDbRuleService.$closeResource(throwable, (AutoCloseable)ruleDaos);
                        }
                        throw throwable3;
                    }
                }
                catch (MongoException e) {
                    log.error("Unable to load processing rules", (Throwable)e);
                    return Collections.emptySet();
                }
            }
            MongoDbRuleService.$closeResource(throwable, (AutoCloseable)ruleDaos);
        }
        return immutableSet;
    }

    @Override
    public void delete(String id) {
        WriteResult result = this.dbCollection.removeById((Object)id);
        if (result.getN() != 1) {
            log.error("Unable to delete rule {}", (Object)id);
        }
        this.clusterBus.post(RulesChangedEvent.deletedRuleId(id));
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        ImmutableSet immutableSet;
        block8: {
            DBCursor ruleDaos = this.dbCollection.find(DBQuery.in((String)"title", ruleNames));
            Throwable throwable = null;
            try {
                immutableSet = ImmutableSet.copyOf((Iterable)ruleDaos);
                if (ruleDaos == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (ruleDaos != null) {
                            MongoDbRuleService.$closeResource(throwable, (AutoCloseable)ruleDaos);
                        }
                        throw throwable3;
                    }
                }
                catch (MongoException e) {
                    log.error("Unable to bulk load rules", (Throwable)e);
                    return Collections.emptySet();
                }
            }
            MongoDbRuleService.$closeResource(throwable, (AutoCloseable)ruleDaos);
        }
        return immutableSet;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

