/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions;

import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.grok.GrokPatternRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokExists
extends AbstractFunction<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(GrokExists.class);
    public static final String NAME = "grok_exists";
    private final ParameterDescriptor<String, String> patternParam;
    private final ParameterDescriptor<Boolean, Boolean> doLog;
    private final GrokPatternRegistry grokPatternRegistry;

    @Inject
    public GrokExists(GrokPatternRegistry grokPatternRegistry) {
        this.grokPatternRegistry = grokPatternRegistry;
        this.patternParam = ParameterDescriptor.string("pattern").description("The Grok Pattern which is to be tested for existance.").build();
        this.doLog = ParameterDescriptor.bool("log_missing").optional().description("Log if the Grok Pattern is missing. Warning: Switching on this flag can lead to a high volume of logs.").build();
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String pattern = this.patternParam.required(args, context);
        boolean logWhenNotFound = this.doLog.optional(args, context).orElse(false);
        if (pattern == null) {
            return null;
        }
        boolean patternExists = this.grokPatternRegistry.grokPatternExists(pattern);
        if (!patternExists && logWhenNotFound) {
            log.info("Grok Pattern " + pattern + " does not exists.");
        }
        return patternExists;
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.patternParam, this.doLog)).description("Checks if the given Grok pattern exists.").build();
    }
}

