/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class MapConversion
extends AbstractFunction<Map> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String NAME = "to_map";
    private static final String VALUE = "value";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("Map-like value to convert").build();

    @Override
    public Map evaluate(FunctionArgs args, EvaluationContext context) {
        Object value = this.valueParam.required(args, context);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        if (value instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)value;
            return (Map)MAPPER.convertValue((Object)jsonNode, Map.class);
        }
        return Collections.emptyMap();
    }

    @Override
    public FunctionDescriptor<Map> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Map.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Converts a map-like value into a map usable by set_fields()").build();
    }
}

