/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class RenameField
extends AbstractFunction<Void> {
    public static final String NAME = "rename_field";
    private final ParameterDescriptor<String, String> oldFieldParam = ParameterDescriptor.string("old_field").description("The old name of the field").build();
    private final ParameterDescriptor<String, String> newFieldParam = ParameterDescriptor.string("new_field").description("The new name of the field").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        String oldName = this.oldFieldParam.required(args, context);
        String newName = this.newFieldParam.required(args, context);
        if (oldName != null && oldName.equals(newName)) {
            return null;
        }
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        if (message.hasField(oldName)) {
            message.addField(newName, message.getField(oldName));
            message.removeField(oldName);
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params(this.oldFieldParam, this.newFieldParam, this.messageParam).description("Rename a message field").build();
    }
}

