/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class FirstNonNull
extends AbstractFunction<Object> {
    public static final String NAME = "first_non_null";
    private final ParameterDescriptor<List, List> valueParam = ParameterDescriptor.type("value", List.class, List.class).description("The list of fields to find first non null value").build();

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        List elements = this.valueParam.required(args, context);
        return elements.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(false).returnType(Object.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Returns first non null element found in value").build();
    }
}

