/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.filter;

import java.util.function.Predicate;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class ActiveSidecarFilter
implements Predicate<Sidecar> {
    private final Period timeoutPeriod;

    public ActiveSidecarFilter(Period timeoutPeriod) {
        this.timeoutPeriod = timeoutPeriod;
    }

    @Override
    public boolean test(Sidecar sidecar) {
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)this.timeoutPeriod);
        return sidecar.lastSeen().isAfter((ReadableInstant)threshold);
    }
}

