/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.migrations;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.graylog.plugins.sidecar.common.SidecarPluginConfiguration;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.MigrationHelpers;
import org.graylog2.users.RoleService;

public class V20180323150000_AddSidecarUser
extends Migration {
    private final RoleService roleService;
    private final String sidecarUser;
    private final MigrationHelpers helpers;

    @Inject
    public V20180323150000_AddSidecarUser(SidecarPluginConfiguration pluginConfiguration, RoleService roleService, MigrationHelpers migrationHelpers) {
        this.roleService = roleService;
        this.sidecarUser = pluginConfiguration.getUser();
        this.helpers = migrationHelpers;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-03-23T15:00:00Z");
    }

    @Override
    public void upgrade() {
        String roleId = this.helpers.ensureBuiltinRole("Sidecar System (Internal)", "Internal technical role. Grants access to register and pull configurations for a Sidecar node (built-in)", (Set<String>)ImmutableSet.of((Object)"sidecar_collectors:read", (Object)"sidecar_collector_configurations:read", (Object)"sidecars:update"));
        this.helpers.ensureUser(this.sidecarUser, UUID.randomUUID().toString(), "Sidecar", "System User (built-in)", "sidecar@graylog.local", Sets.newHashSet((Object[])new String[]{roleId, this.roleService.getReaderRoleObjectId()}), true);
    }
}

