/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.graylog.plugins.sidecar.rest.models.AutoValue_Sidecar;
import org.graylog.plugins.sidecar.rest.models.NodeDetails;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@AutoValue
public abstract class Sidecar {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NODE_ID = "node_id";
    public static final String FIELD_NODE_NAME = "node_name";
    public static final String FIELD_NODE_DETAILS = "node_details";
    public static final String FIELD_ASSIGNMENTS = "assignments";
    public static final String FIELD_SIDECAR_VERSION = "sidecar_version";
    public static final String FIELD_LAST_SEEN = "last_seen";
    public static final String FIELD_OPERATING_SYSTEM = "node_details.operating_system";
    public static final String FIELD_STATUS = "node_details.status.status";

    @JsonProperty
    @Id
    @ObjectId
    @Nullable
    public abstract String id();

    @JsonProperty
    public abstract String nodeId();

    @JsonProperty
    public abstract String nodeName();

    @JsonProperty
    public abstract NodeDetails nodeDetails();

    @JsonProperty
    @Nullable
    public abstract List<ConfigurationAssignment> assignments();

    @JsonProperty
    public abstract String sidecarVersion();

    @JsonProperty
    public abstract DateTime lastSeen();

    public static Builder builder() {
        return new AutoValue_Sidecar.Builder();
    }

    public abstract Builder toBuilder();

    @JsonCreator
    public static Sidecar create(@JsonProperty(value="id") @Id @ObjectId String id, @JsonProperty(value="node_id") String nodeId, @JsonProperty(value="node_name") String nodeName, @JsonProperty(value="node_details") NodeDetails nodeDetails, @JsonProperty(value="assignments") @Nullable List<ConfigurationAssignment> assignments, @JsonProperty(value="sidecar_version") String sidecarVersion, @JsonProperty(value="last_seen") DateTime lastSeen) {
        return Sidecar.builder().id(id).nodeId(nodeId).nodeName(nodeName).nodeDetails(nodeDetails).assignments(assignments).sidecarVersion(sidecarVersion).lastSeen(lastSeen).build();
    }

    public static Sidecar create(@JsonProperty(value="node_id") String nodeId, @JsonProperty(value="node_name") String nodeName, @JsonProperty(value="node_details") NodeDetails nodeDetails, @JsonProperty(value="sidecar_version") String sidecarVersion) {
        return Sidecar.builder().id(new org.bson.types.ObjectId().toHexString()).nodeId(nodeId).nodeName(nodeName).nodeDetails(nodeDetails).sidecarVersion(sidecarVersion).lastSeen(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
    }

    public SidecarSummary toSummary(Predicate<Sidecar> isActiveFunction) {
        return SidecarSummary.builder().nodeId(this.nodeId()).nodeName(this.nodeName()).nodeDetails(this.nodeDetails()).assignments((List)MoreObjects.firstNonNull(this.assignments(), new ArrayList())).lastSeen(this.lastSeen()).sidecarVersion(this.sidecarVersion()).active(isActiveFunction != null && isActiveFunction.test(this)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder nodeId(String var1);

        public abstract Builder nodeName(String var1);

        public abstract Builder nodeDetails(NodeDetails var1);

        public abstract Builder assignments(List<ConfigurationAssignment> var1);

        public abstract Builder sidecarVersion(String var1);

        public abstract Builder lastSeen(DateTime var1);

        public abstract Sidecar build();
    }

    public static enum Status {
        RUNNING(0),
        UNKNOWN(1),
        FAILING(2),
        STOPPED(3);

        private final int statusCode;

        private Status(int statusCode) {
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public static Status fromStatusCode(int statusCode) {
            switch (statusCode) {
                case 0: {
                    return RUNNING;
                }
                case 2: {
                    return FAILING;
                }
                case 3: {
                    return STOPPED;
                }
            }
            return UNKNOWN;
        }

        public static Status fromString(String statusString) {
            return Status.valueOf(statusString.toUpperCase(Locale.ENGLISH));
        }
    }
}

