/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.CollectorActions;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class ActionService {
    private static final String COLLECTION_NAME = "sidecar_collector_actions";
    private final JacksonDBCollection<CollectorActions, ObjectId> dbCollection;

    @Inject
    public ActionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), CollectorActions.class, ObjectId.class, (ObjectMapper)mapper.get());
    }

    public CollectorActions fromRequest(String sidecarId, List<CollectorAction> actions) {
        CollectorActions collectorActions = this.findActionBySidecar(sidecarId, false);
        if (collectorActions == null) {
            return CollectorActions.create(sidecarId, DateTime.now((DateTimeZone)DateTimeZone.UTC), actions);
        }
        ArrayList<CollectorAction> updatedActions = new ArrayList<CollectorAction>();
        for (CollectorAction action : actions) {
            for (CollectorAction existingsAction : collectorActions.action()) {
                if (existingsAction.collectorId().equals(action.collectorId())) continue;
                updatedActions.add(existingsAction);
            }
            updatedActions.add(action);
        }
        return CollectorActions.create(collectorActions.id(), sidecarId, DateTime.now((DateTimeZone)DateTimeZone.UTC), updatedActions);
    }

    public CollectorActions saveAction(CollectorActions collectorActions) {
        return (CollectorActions)this.dbCollection.findAndModify(DBQuery.is((String)"sidecar_id", (Object)collectorActions.sidecarId()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)collectorActions, true, true);
    }

    public CollectorActions findActionBySidecar(String sidecarId, boolean remove) {
        if (remove) {
            return (CollectorActions)this.dbCollection.findAndRemove(DBQuery.is((String)"sidecar_id", (Object)sidecarId));
        }
        return (CollectorActions)this.dbCollection.findOne(DBQuery.is((String)"sidecar_id", (Object)sidecarId));
    }
}

