/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.inject.Inject;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.migrations.AutoValue_V20190127111728_MigrateWidgetFormatSettings_MigrationCompleted;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20190127111728_MigrateWidgetFormatSettings
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190127111728_MigrateWidgetFormatSettings.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> viewsCollection;

    @Inject
    public V20190127111728_MigrateWidgetFormatSettings(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.viewsCollection = mongoConnection.getMongoDatabase().getCollection("views");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-01-27T11:17:28Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        HashSet<String> viewIds = new HashSet<String>();
        FindIterable documents = this.viewsCollection.find();
        for (Document view : documents) {
            boolean viewMigrated = false;
            Document states = (Document)view.get((Object)"state", Document.class);
            for (Map.Entry obj : states.entrySet()) {
                Document state = (Document)obj.getValue();
                if (!(state.get((Object)"widgets") instanceof List)) continue;
                List widgets = (List)state.get((Object)"widgets");
                for (Document widget : widgets) {
                    Object charColorsObj;
                    Document config;
                    Document formatSettings;
                    String type = widget.getString((Object)"type");
                    if (!type.equals("aggregation") || (formatSettings = (Document)(config = (Document)widget.get((Object)"config", Document.class)).get((Object)"formatting_settings", Document.class)) == null || (charColorsObj = formatSettings.get((Object)"chart_colors")) == null) continue;
                    viewMigrated = true;
                    Map chartColors = (Map)charColorsObj;
                    List chartColorSettings = chartColors.entrySet().stream().map(entry -> {
                        Document chartColorFieldSetting = new Document();
                        chartColorFieldSetting.put("field_name", entry.getKey());
                        chartColorFieldSetting.put("chart_color", entry.getValue());
                        return chartColorFieldSetting;
                    }).collect(Collectors.toList());
                    formatSettings.put("chart_colors", chartColorSettings);
                    config.put("formatting_settings", (Object)formatSettings);
                    widget.put("config", (Object)config);
                }
                if (!viewMigrated) continue;
                state.put("widgets", (Object)widgets);
            }
            if (!viewMigrated) continue;
            this.viewsCollection.updateOne((Bson)new BasicDBObject("_id", (Object)view.getObjectId((Object)"_id")), (Bson)new Document("$set", (Object)view));
            String viewId = view.getObjectId((Object)"_id").toString();
            viewIds.add(viewId);
        }
        LOG.info("Migration completed. {} views where migrated.", (Object)viewIds.size());
        this.clusterConfigService.write(MigrationCompleted.create(viewIds.size(), viewIds));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="modified_views_count")
        public abstract long modifiedViewsCount();

        @JsonProperty(value="modified_view_ids")
        public abstract Set<String> modifiedViewIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="modified_views_count") long modifiedViews, @JsonProperty(value="modified_view_ids") Set<String> modifiedViewIds) {
            return new AutoValue_V20190127111728_MigrateWidgetFormatSettings_MigrationCompleted(modifiedViews, modifiedViewIds);
        }
    }
}

