/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.time.Duration;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.AbsoluteRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RelativeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AutoInterval;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Interval;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.TimeUnitInterval;

public class ApproximatedAutoIntervalFactory {
    static final ImmutableRangeMap<Duration, Duration> boundaries = ImmutableRangeMap.builder().put(Range.atMost((Comparable)Duration.ofMillis(20L)), (Object)Duration.ofMillis(1L)).put(Range.openClosed((Comparable)Duration.ofMillis(20L), (Comparable)Duration.ofMillis(200L)), (Object)Duration.ofMillis(5L)).put(Range.openClosed((Comparable)Duration.ofMillis(200L), (Comparable)Duration.ofMillis(500L)), (Object)Duration.ofMillis(10L)).put(Range.openClosed((Comparable)Duration.ofMillis(500L), (Comparable)Duration.ofMillis(1000L)), (Object)Duration.ofMillis(20L)).put(Range.openClosed((Comparable)Duration.ofMillis(1000L), (Comparable)Duration.ofSeconds(2L)), (Object)Duration.ofMillis(40L)).put(Range.openClosed((Comparable)Duration.ofSeconds(2L), (Comparable)Duration.ofSeconds(10L)), (Object)Duration.ofMillis(200L)).put(Range.openClosed((Comparable)Duration.ofSeconds(10L), (Comparable)Duration.ofSeconds(30L)), (Object)Duration.ofMillis(500L)).put(Range.openClosed((Comparable)Duration.ofSeconds(30L), (Comparable)Duration.ofMinutes(1L)), (Object)Duration.ofSeconds(1L)).put(Range.openClosed((Comparable)Duration.ofMinutes(1L), (Comparable)Duration.ofMinutes(2L)), (Object)Duration.ofSeconds(2L)).put(Range.openClosed((Comparable)Duration.ofMinutes(2L), (Comparable)Duration.ofMinutes(4L)), (Object)Duration.ofSeconds(5L)).put(Range.openClosed((Comparable)Duration.ofMinutes(4L), (Comparable)Duration.ofMinutes(7L)), (Object)Duration.ofSeconds(10L)).put(Range.openClosed((Comparable)Duration.ofMinutes(7L), (Comparable)Duration.ofMinutes(10L)), (Object)Duration.ofSeconds(20L)).put(Range.openClosed((Comparable)Duration.ofMinutes(10L), (Comparable)Duration.ofMinutes(30L)), (Object)Duration.ofSeconds(30L)).put(Range.openClosed((Comparable)Duration.ofMinutes(30L), (Comparable)Duration.ofHours(1L)), (Object)Duration.ofMinutes(1L)).put(Range.openClosed((Comparable)Duration.ofHours(1L), (Comparable)Duration.ofHours(2L)), (Object)Duration.ofMinutes(2L)).put(Range.openClosed((Comparable)Duration.ofHours(2L), (Comparable)Duration.ofHours(4L)), (Object)Duration.ofMinutes(5L)).put(Range.openClosed((Comparable)Duration.ofHours(4L), (Comparable)Duration.ofHours(12L)), (Object)Duration.ofMinutes(10L)).put(Range.openClosed((Comparable)Duration.ofHours(12L), (Comparable)Duration.ofHours(16L)), (Object)Duration.ofMinutes(15L)).put(Range.openClosed((Comparable)Duration.ofHours(16L), (Comparable)Duration.ofDays(1L)), (Object)Duration.ofMinutes(30L)).put(Range.openClosed((Comparable)Duration.ofDays(1L), (Comparable)Duration.ofDays(2L)), (Object)Duration.ofHours(1L)).put(Range.openClosed((Comparable)Duration.ofDays(2L), (Comparable)Duration.ofDays(4L)), (Object)Duration.ofHours(2L)).put(Range.openClosed((Comparable)Duration.ofDays(4L), (Comparable)Duration.ofDays(10L)), (Object)Duration.ofHours(4L)).put(Range.openClosed((Comparable)Duration.ofDays(10L), (Comparable)Duration.ofDays(12L)), (Object)Duration.ofHours(6L)).put(Range.openClosed((Comparable)Duration.ofDays(12L), (Comparable)Duration.ofDays(28L)), (Object)Duration.ofHours(12L)).put(Range.openClosed((Comparable)Duration.ofDays(28L), (Comparable)Duration.ofDays(60L)), (Object)Duration.ofDays(1L)).put(Range.openClosed((Comparable)Duration.ofDays(60L), (Comparable)Duration.ofDays(120L)), (Object)Duration.ofDays(2L)).put(Range.openClosed((Comparable)Duration.ofDays(120L), (Comparable)Duration.ofDays(180L)), (Object)Duration.ofDays(3L)).put(Range.openClosed((Comparable)Duration.ofDays(180L), (Comparable)Duration.ofDays(365L)), (Object)Duration.ofDays(7L)).put(Range.open((Comparable)Duration.ofDays(365L), (Comparable)Duration.ofDays(730L)), (Object)Duration.ofDays(14L)).put(Range.atLeast((Comparable)Duration.ofDays(730L)), (Object)Duration.ofDays(30L)).build();

    private static Double scalingForAutoTimeRange(long durationOfTimeRangeInSeconds, Duration durationOfTimeRange) {
        Duration autoIntervalDuration = (Duration)boundaries.get((Comparable)Duration.ofSeconds(durationOfTimeRangeInSeconds));
        return (double)autoIntervalDuration.getSeconds() / (double)durationOfTimeRange.getSeconds();
    }

    private static Duration parseInterval(String interval) {
        switch (interval) {
            case "minute": {
                return Duration.ofMinutes(1L);
            }
            case "hour": {
                return Duration.ofHours(1L);
            }
            case "day": {
                return Duration.ofDays(1L);
            }
            case "week": {
                return Duration.ofDays(7L);
            }
            case "month": {
                return Duration.ofDays(30L);
            }
            case "quarter": {
                return Duration.ofDays(90L);
            }
            case "year": {
                return Duration.ofDays(365L);
            }
        }
        throw new RuntimeException("Unable to parse interval: " + interval);
    }

    private static Interval timestampInterval(String interval) {
        switch (interval) {
            case "minute": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.MINUTES, 1);
            }
            case "hour": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.HOURS, 1);
            }
            case "day": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.DAYS, 1);
            }
            case "week": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.WEEKS, 1);
            }
            case "month": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.MONTHS, 1);
            }
            case "quarter": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.MONTHS, 3);
            }
            case "year": {
                return TimeUnitInterval.create(TimeUnitInterval.IntervalUnit.YEARS, 1);
            }
        }
        throw new RuntimeException("Unable to map interval: " + interval);
    }

    private static Interval ofAbsoluteRange(String interval, AbsoluteRange absoluteRange) {
        Duration duration = ApproximatedAutoIntervalFactory.parseInterval(interval);
        long absoluteTimeRangeDurationInSeconds = (absoluteRange.to().getMillis() - absoluteRange.from().getMillis()) / 1000L;
        double absoluteScaling = ApproximatedAutoIntervalFactory.scalingForAutoTimeRange(absoluteTimeRangeDurationInSeconds, duration);
        if (absoluteScaling < 0.5 || absoluteScaling > 8.0) {
            return ApproximatedAutoIntervalFactory.timestampInterval(interval);
        }
        return AutoInterval.create(absoluteScaling);
    }

    private static Interval ofRelativeRange(String interval, RelativeRange relativeRange) {
        Duration duration = ApproximatedAutoIntervalFactory.parseInterval(interval);
        long relativeTimeRangeDurationInSeconds = relativeRange.range();
        double relativeScaling = ApproximatedAutoIntervalFactory.scalingForAutoTimeRange(relativeTimeRangeDurationInSeconds, duration);
        if (relativeScaling < 0.5 || relativeScaling > 8.0) {
            return ApproximatedAutoIntervalFactory.timestampInterval(interval);
        }
        return AutoInterval.create(relativeScaling);
    }

    public static Interval of(String interval, TimeRange timeRange) {
        switch (timeRange.type()) {
            case "keyword": {
                return ApproximatedAutoIntervalFactory.timestampInterval(interval);
            }
            case "absolute": {
                return ApproximatedAutoIntervalFactory.ofAbsoluteRange(interval, (AbsoluteRange)timeRange);
            }
            case "relative": {
                return ApproximatedAutoIntervalFactory.ofRelativeRange(interval, (RelativeRange)timeRange);
            }
        }
        throw new RuntimeException("Unable to parse time range type: " + timeRange.type());
    }
}

