/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.BucketSpec;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Time;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Values;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AutoValue_Pivot;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.PivotConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.TimeHistogramConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.ValueConfig;

@AutoValue
public abstract class Pivot {
    private static final String TYPE_TIME = "time";
    private static final String TYPE_VALUES = "values";
    static final String FIELD_FIELD_NAME = "field";
    static final String FIELD_TYPE = "type";
    static final String FIELD_CONFIG = "config";

    @JsonProperty(value="field")
    public abstract String field();

    @JsonProperty(value="type")
    public abstract String type();

    @JsonProperty(value="config")
    public abstract PivotConfig config();

    public static Builder timeBuilder() {
        return new AutoValue_Pivot.Builder().type(TYPE_TIME);
    }

    public static Builder valuesBuilder() {
        return new AutoValue_Pivot.Builder().type(TYPE_VALUES);
    }

    public BucketSpec toBucketSpec() {
        switch (this.type()) {
            case "time": {
                TimeHistogramConfig timeConfig = (TimeHistogramConfig)this.config();
                return Time.create(this.field(), timeConfig.interval().toBucketInterval());
            }
            case "values": {
                ValueConfig valueConfig = (ValueConfig)this.config();
                return Values.create(this.field(), valueConfig.limit());
            }
        }
        throw new RuntimeException("Invalid pivot type when creating bucket spec: " + this.type());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder field(String var1);

        public abstract Builder config(PivotConfig var1);

        public abstract Builder type(String var1);

        public abstract Pivot build();
    }
}

