/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class LegacyDecoratorProcessor {
    private final DecoratorProcessor decoratorProcessor;
    private final Map<String, SearchResponseDecorator.Factory> searchResponseDecorators;

    @Inject
    public LegacyDecoratorProcessor(DecoratorProcessor decoratorProcessor, Map<String, SearchResponseDecorator.Factory> searchResponseDecorators) {
        this.decoratorProcessor = decoratorProcessor;
        this.searchResponseDecorators = searchResponseDecorators;
    }

    public SearchResponse decorateSearchResponse(SearchResponse searchResponse, List<Decorator> decorators) {
        if (decorators.isEmpty()) {
            return searchResponse;
        }
        List<SearchResponseDecorator> searchResponseDecorators = decorators.stream().sorted(Comparator.comparing(Decorator::order)).map(decorator -> this.searchResponseDecorators.get(decorator.type()).create((Decorator)decorator)).collect(Collectors.toList());
        return this.decoratorProcessor.decorate(searchResponse, searchResponseDecorators);
    }

    public static class Fake
    extends LegacyDecoratorProcessor {
        public Fake() {
            super(null, null);
        }

        @Override
        public SearchResponse decorateSearchResponse(SearchResponse searchResponse, List<Decorator> decorators) {
            return searchResponse;
        }
    }
}

