/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import one.util.streamex.EntryStream;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.errors.SearchError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
@JsonPropertyOrder(value={"execution", "results"})
public class SearchJob {
    private static final Logger LOG = LoggerFactory.getLogger(SearchJob.class);
    static final String FIELD_OWNER = "owner";
    @JsonProperty
    private final String id;
    @JsonIgnore
    private final Search search;
    @JsonProperty
    private final String owner;
    @JsonIgnore
    private CompletableFuture<Void> resultFuture;
    private Map<String, CompletableFuture<QueryResult>> queryResults = Maps.newHashMap();
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<SearchError> errors = Sets.newHashSet();

    public SearchJob(String id, Search search, String owner) {
        this.id = id;
        this.search = search;
        this.owner = owner;
    }

    public String getId() {
        return this.id;
    }

    public Search getSearch() {
        return this.search;
    }

    @JsonProperty(value="search_id")
    public String getSearchId() {
        return this.search.id();
    }

    public String getOwner() {
        return this.owner;
    }

    public CompletableFuture<Void> getResultFuture() {
        return this.resultFuture;
    }

    public void addQueryResultFuture(String queryId, CompletableFuture<QueryResult> resultFuture) {
        this.queryResults.put(queryId, resultFuture);
    }

    @JsonProperty(value="results")
    public Map<String, QueryResult> results() {
        return EntryStream.of(this.queryResults).mapValues(future -> future.getNow(QueryResult.incomplete())).filterKeys(queryId -> !queryId.isEmpty()).filterValues(r -> r.state() == QueryResult.State.COMPLETED || r.state() == QueryResult.State.FAILED).toMap();
    }

    @JsonProperty(value="execution")
    public ExecutionInfo execution() {
        return new ExecutionInfo(this.resultFuture.isDone(), this.resultFuture.isCancelled(), !this.errors.isEmpty());
    }

    public CompletableFuture<QueryResult> getQueryResultFuture(String queryId) {
        return this.queryResults.get(queryId);
    }

    public SearchJob seal() {
        this.resultFuture = CompletableFuture.allOf(this.queryResults.values().toArray(new CompletableFuture[0]));
        return this;
    }

    public void addError(SearchError t) {
        this.errors.add(t);
    }

    private static class ExecutionInfo {
        @JsonProperty(value="done")
        private final boolean done;
        @JsonProperty(value="cancelled")
        private final boolean cancelled;
        @JsonProperty(value="completed_exceptionally")
        private final boolean hasErrors;

        ExecutionInfo(boolean done, boolean cancelled, boolean hasErrors) {
            this.done = done;
            this.cancelled = cancelled;
            this.hasErrors = hasErrors;
        }
    }
}

