/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.util.GraphToDot;

public class QueryPlan {
    private final QueryEngine queryEngine;
    private final SearchJob searchJob;
    private ImmutableGraph<Query> plan;
    private final Query rootNode = Query.emptyRoot();

    public QueryPlan(QueryEngine queryEngine, SearchJob searchJob) {
        this.queryEngine = queryEngine;
        this.searchJob = searchJob;
        this.plan();
    }

    protected CompletableFuture<Void> plan() {
        MutableGraph planGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        planGraph.addNode((Object)this.rootNode);
        Search search = this.searchJob.getSearch();
        for (Query currentQuery : search.queries()) {
            QueryMetadata queryMetadata = this.queryEngine.parse(search, currentQuery);
            ImmutableSet<String> referencedQueries = queryMetadata.referencedQueries().isEmpty() ? Collections.singleton(this.rootNode.id()) : queryMetadata.referencedQueries();
            for (String sourceQueryId : referencedQueries) {
                Query sourceQuery = search.getQuery(sourceQueryId).orElse(this.rootNode);
                planGraph.addNode((Object)sourceQuery);
                planGraph.addNode((Object)currentQuery);
                planGraph.putEdge((Object)sourceQuery, (Object)currentQuery);
            }
        }
        this.plan = ImmutableGraph.copyOf((Graph)planGraph);
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("searchJob", (Object)this.searchJob).add("plan", this.plan).add("dot", (Object)GraphToDot.toDot(this.plan, Query::id, query -> MoreObjects.firstNonNull((Object)query.query(), (Object)"Root").toString())).toString();
    }

    public Stream<Query> queryStream() {
        return this.breadthFirst().filter(element -> !this.rootNode.equals(element));
    }

    public Stream<Query> breadthFirst() {
        return StreamSupport.stream(Traverser.forGraph(this.plan).breadthFirst((Object)this.rootNode).spliterator(), false);
    }

    public ImmutableList<Query> queries() {
        return (ImmutableList)this.queryStream().collect(ImmutableList.toImmutableList());
    }

    public Set<Query> predecessors(Query query) {
        return this.plan.predecessors((Object)query);
    }

    public Set<Query> successors(Query query) {
        return this.plan.successors((Object)query);
    }
}

