/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.errors;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.errors.ResultWindowLimitError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog2.indexer.ElasticsearchException;

public class SearchTypeErrorParser {
    public static SearchTypeError parse(Query query, String searchTypeId, ElasticsearchException ex) {
        Integer resultWindowLimit = SearchTypeErrorParser.parseResultLimit(ex);
        if (resultWindowLimit != null) {
            return new ResultWindowLimitError(query, searchTypeId, resultWindowLimit, ex);
        }
        return new SearchTypeError(query, searchTypeId, ex);
    }

    private static Integer parseResultLimit(Throwable throwable) {
        return SearchTypeErrorParser.parseResultLimit(throwable.getMessage());
    }

    private static Integer parseResultLimit(String description) {
        Matcher matcher;
        if (description.toLowerCase(Locale.US).contains("result window is too large") && (matcher = Pattern.compile("[0-9]+").matcher(description)).find()) {
            return Integer.parseInt(matcher.group(0));
        }
        return null;
    }
}

