/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

final class AutoValue_ExportMessagesCommand
extends ExportMessagesCommand {
    private final AbsoluteRange timeRange;
    private final ElasticsearchQueryString queryString;
    private final Set<String> streams;
    private final LinkedHashSet<String> fieldsInOrder;
    private final List<Decorator> decorators;
    private final int chunkSize;
    private final OptionalInt limit;

    private AutoValue_ExportMessagesCommand(AbsoluteRange timeRange, ElasticsearchQueryString queryString, Set<String> streams, LinkedHashSet<String> fieldsInOrder, List<Decorator> decorators, int chunkSize, OptionalInt limit) {
        this.timeRange = timeRange;
        this.queryString = queryString;
        this.streams = streams;
        this.fieldsInOrder = fieldsInOrder;
        this.decorators = decorators;
        this.chunkSize = chunkSize;
        this.limit = limit;
    }

    @Override
    public AbsoluteRange timeRange() {
        return this.timeRange;
    }

    @Override
    public ElasticsearchQueryString queryString() {
        return this.queryString;
    }

    @Override
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    public LinkedHashSet<String> fieldsInOrder() {
        return this.fieldsInOrder;
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public OptionalInt limit() {
        return this.limit;
    }

    public String toString() {
        return "ExportMessagesCommand{timeRange=" + this.timeRange + ", queryString=" + this.queryString + ", streams=" + this.streams + ", fieldsInOrder=" + this.fieldsInOrder + ", decorators=" + this.decorators + ", chunkSize=" + this.chunkSize + ", limit=" + this.limit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExportMessagesCommand) {
            ExportMessagesCommand that = (ExportMessagesCommand)o;
            return this.timeRange.equals(that.timeRange()) && this.queryString.equals(that.queryString()) && this.streams.equals(that.streams()) && this.fieldsInOrder.equals(that.fieldsInOrder()) && this.decorators.equals(that.decorators()) && this.chunkSize == that.chunkSize() && this.limit.equals(that.limit());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.timeRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.fieldsInOrder.hashCode();
        h$ *= 1000003;
        h$ ^= this.decorators.hashCode();
        h$ *= 1000003;
        h$ ^= this.chunkSize;
        h$ *= 1000003;
        return h$ ^= this.limit.hashCode();
    }

    @Override
    public ExportMessagesCommand.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ExportMessagesCommand.Builder {
        private AbsoluteRange timeRange;
        private ElasticsearchQueryString queryString;
        private Set<String> streams;
        private LinkedHashSet<String> fieldsInOrder;
        private List<Decorator> decorators;
        private Integer chunkSize;
        private OptionalInt limit = OptionalInt.empty();

        Builder() {
        }

        private Builder(ExportMessagesCommand source) {
            this.timeRange = source.timeRange();
            this.queryString = source.queryString();
            this.streams = source.streams();
            this.fieldsInOrder = source.fieldsInOrder();
            this.decorators = source.decorators();
            this.chunkSize = source.chunkSize();
            this.limit = source.limit();
        }

        @Override
        public ExportMessagesCommand.Builder timeRange(AbsoluteRange timeRange) {
            if (timeRange == null) {
                throw new NullPointerException("Null timeRange");
            }
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder queryString(ElasticsearchQueryString queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder streams(Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
            if (fieldsInOrder == null) {
                throw new NullPointerException("Null fieldsInOrder");
            }
            this.fieldsInOrder = fieldsInOrder;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder decorators(List<Decorator> decorators) {
            if (decorators == null) {
                throw new NullPointerException("Null decorators");
            }
            this.decorators = decorators;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        @Override
        public ExportMessagesCommand.Builder limit(Integer limit) {
            this.limit = OptionalInt.of(limit);
            return this;
        }

        @Override
        ExportMessagesCommand autoBuild() {
            String missing = "";
            if (this.timeRange == null) {
                missing = missing + " timeRange";
            }
            if (this.queryString == null) {
                missing = missing + " queryString";
            }
            if (this.streams == null) {
                missing = missing + " streams";
            }
            if (this.fieldsInOrder == null) {
                missing = missing + " fieldsInOrder";
            }
            if (this.decorators == null) {
                missing = missing + " decorators";
            }
            if (this.chunkSize == null) {
                missing = missing + " chunkSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ExportMessagesCommand(this.timeRange, this.queryString, this.streams, this.fieldsInOrder, this.decorators, this.chunkSize, this.limit);
        }
    }
}

