/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.OptionalInt;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_MessagesRequest
extends MessagesRequest {
    private final TimeRange timeRange;
    private final ElasticsearchQueryString queryString;
    private final Set<String> streams;
    @NotEmpty
    private final LinkedHashSet<String> fieldsInOrder;
    private final int chunkSize;
    @Positive
    private final OptionalInt limit;

    private AutoValue_MessagesRequest(TimeRange timeRange, ElasticsearchQueryString queryString, Set<String> streams, @NotEmpty LinkedHashSet<String> fieldsInOrder, int chunkSize, @Positive OptionalInt limit) {
        this.timeRange = timeRange;
        this.queryString = queryString;
        this.streams = streams;
        this.fieldsInOrder = fieldsInOrder;
        this.chunkSize = chunkSize;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="timerange")
    public TimeRange timeRange() {
        return this.timeRange;
    }

    @Override
    @JsonProperty(value="query_string")
    public ElasticsearchQueryString queryString() {
        return this.queryString;
    }

    @Override
    @JsonProperty
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    @JsonProperty(value="fields_in_order")
    @NotEmpty
    public LinkedHashSet<String> fieldsInOrder() {
        return this.fieldsInOrder;
    }

    @Override
    @JsonProperty(value="chunk_size")
    public int chunkSize() {
        return this.chunkSize;
    }

    @Override
    @JsonProperty
    @Positive
    public OptionalInt limit() {
        return this.limit;
    }

    public String toString() {
        return "MessagesRequest{timeRange=" + this.timeRange + ", queryString=" + this.queryString + ", streams=" + this.streams + ", fieldsInOrder=" + this.fieldsInOrder + ", chunkSize=" + this.chunkSize + ", limit=" + this.limit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MessagesRequest) {
            MessagesRequest that = (MessagesRequest)o;
            return this.timeRange.equals(that.timeRange()) && this.queryString.equals(that.queryString()) && this.streams.equals(that.streams()) && this.fieldsInOrder.equals(that.fieldsInOrder()) && this.chunkSize == that.chunkSize() && this.limit.equals(that.limit());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.timeRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.fieldsInOrder.hashCode();
        h$ *= 1000003;
        h$ ^= this.chunkSize;
        h$ *= 1000003;
        return h$ ^= this.limit.hashCode();
    }

    @Override
    public MessagesRequest.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MessagesRequest.Builder {
        private TimeRange timeRange;
        private ElasticsearchQueryString queryString;
        private Set<String> streams;
        @NotEmpty
        private LinkedHashSet<String> fieldsInOrder;
        private Integer chunkSize;
        @Positive
        private OptionalInt limit = OptionalInt.empty();

        Builder() {
        }

        private Builder(MessagesRequest source) {
            this.timeRange = source.timeRange();
            this.queryString = source.queryString();
            this.streams = source.streams();
            this.fieldsInOrder = source.fieldsInOrder();
            this.chunkSize = source.chunkSize();
            this.limit = source.limit();
        }

        @Override
        public MessagesRequest.Builder timeRange(TimeRange timeRange) {
            if (timeRange == null) {
                throw new NullPointerException("Null timeRange");
            }
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public MessagesRequest.Builder queryString(ElasticsearchQueryString queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        public MessagesRequest.Builder streams(Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public MessagesRequest.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
            if (fieldsInOrder == null) {
                throw new NullPointerException("Null fieldsInOrder");
            }
            this.fieldsInOrder = fieldsInOrder;
            return this;
        }

        @Override
        public MessagesRequest.Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        @Override
        public MessagesRequest.Builder limit(Integer limit) {
            this.limit = OptionalInt.of(limit);
            return this;
        }

        @Override
        public MessagesRequest build() {
            String missing = "";
            if (this.timeRange == null) {
                missing = missing + " timeRange";
            }
            if (this.queryString == null) {
                missing = missing + " queryString";
            }
            if (this.streams == null) {
                missing = missing + " streams";
            }
            if (this.fieldsInOrder == null) {
                missing = missing + " fieldsInOrder";
            }
            if (this.chunkSize == null) {
                missing = missing + " chunkSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MessagesRequest(this.timeRange, this.queryString, this.streams, this.fieldsInOrder, this.chunkSize, this.limit);
        }
    }
}

