/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

public class PermittedStreams {
    private final StreamService streamService;

    @Inject
    public PermittedStreams(StreamService streamService) {
        this.streamService = streamService;
    }

    public ImmutableSet<String> load(Predicate<String> isStreamIdPermitted) {
        Set result = this.streamService.loadAll().stream().map(Persisted::getId).filter(id -> !Stream.NON_MESSAGE_STREAM_IDS.contains(id)).filter(isStreamIdPermitted).collect(Collectors.toSet());
        return ImmutableSet.copyOf(result);
    }
}

