/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.graylog.plugins.views.search.searchtypes.events.AutoValue_EventSummary;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventSummary {
    private static final String FIELD_ID = "id";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_EVENT_TIMESTAMP = "timestamp";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_ALERT = "alert";

    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="streams")
    public abstract Set<String> streams();

    @JsonProperty(value="timestamp")
    public abstract DateTime timestamp();

    @JsonProperty(value="message")
    public abstract String message();

    @JsonProperty(value="alert")
    public abstract boolean alert();

    public static EventSummary parse(Map<String, Object> rawEvent) {
        return EventSummary.builder().alert((Boolean)rawEvent.get(FIELD_ALERT)).id((String)rawEvent.get(FIELD_ID)).message((String)rawEvent.get(FIELD_MESSAGE)).streams((Set<String>)ImmutableSet.copyOf((Collection)((ArrayList)rawEvent.get("source_streams")))).timestamp(DateTime.parse((String)((String)rawEvent.get(FIELD_EVENT_TIMESTAMP)), (DateTimeFormatter)Tools.ES_DATE_FORMAT_FORMATTER)).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(value={"_id"})
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EventSummary.Builder();
        }

        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="timestamp")
        public abstract Builder timestamp(DateTime var1);

        @JsonProperty(value="message")
        public abstract Builder message(String var1);

        @JsonProperty(value="alert")
        public abstract Builder alert(boolean var1);

        public abstract EventSummary build();
    }
}

