/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.util;

import com.google.common.graph.Graph;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.enums.GraphType;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphToDot {
    private static final Logger LOG = LoggerFactory.getLogger(GraphToDot.class);

    private GraphToDot() {
    }

    public static <N> String toDot(Graph<N> graph, Function<N, String> idFunction, Function<N, String> labelFunction) {
        info.leadinglight.jdot.Graph g = new info.leadinglight.jdot.Graph("QueryPlan");
        g.setType(graph.isDirected() ? GraphType.digraph : GraphType.graph);
        graph.nodes().forEach(node -> {
            Node n = new Node((String)idFunction.apply(node));
            n.setLabel((String)labelFunction.apply(node));
            g.addNode(n);
        });
        graph.edges().forEach(edge -> g.addEdge((String)idFunction.apply(edge.source()), new String[]{(String)idFunction.apply(edge.target())}));
        return g.toDot();
    }
}

