/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.test.AuthServiceBackendTestRequest;
import org.graylog.security.authservice.test.AuthServiceBackendTestService;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.ValidationFailureException;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/system/authentication/services/test")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services/Test", description="Test authentication services")
@RequiresAuthentication
public class AuthServiceTestResource
extends RestResource {
    private final AuthServiceBackendTestService testService;

    @Inject
    public AuthServiceTestResource(AuthServiceBackendTestService testService) {
        this.testService = testService;
    }

    @POST
    @Path(value="backend/connection")
    @ApiOperation(value="Test authentication service backend connection")
    @RequiresPermissions(value={"authservicetestbackend:execute"})
    @NoAuditEvent(value="Test resource - doesn't change any data")
    public Response backendConnection(@ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendTestRequest request) {
        return Response.ok((Object)this.testService.testConnection(request)).build();
    }

    @POST
    @Path(value="backend/login")
    @ApiOperation(value="Test authentication service backend login")
    @RequiresPermissions(value={"authservicetestbackend:execute"})
    @NoAuditEvent(value="Test resource - doesn't change any data")
    public Response backendLogin(@ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendTestRequest request) {
        this.validateConfig(request.backendConfiguration());
        return Response.ok((Object)this.testService.testLogin(request)).build();
    }

    private void validateConfig(AuthServiceBackendDTO config) {
        ValidationResult result = config.validate();
        if (result.failed()) {
            throw new ValidationFailureException(result);
        }
    }
}

