/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authzroles;

import com.google.common.collect.ImmutableSet;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Projections;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.security.authzroles.AuthzRoleDTO;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.graylog2.shared.users.UserService;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class PaginatedAuthzRolesService
extends PaginatedDbService<AuthzRoleDTO> {
    private static final String COLLECTION_NAME = "roles";
    private final MongoCollection<Document> dbCollection;
    private final UserService userService;

    @Inject
    public PaginatedAuthzRolesService(MongoConnection mongoConnection, UserService userService, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, AuthzRoleDTO.class, COLLECTION_NAME);
        this.dbCollection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        this.userService = userService;
    }

    public long count() {
        return this.dbCollection.countDocuments();
    }

    public ImmutableSet<String> getAllRoleIds() {
        FindIterable docs = this.dbCollection.find().projection(Projections.include((String[])new String[]{"_id"}));
        return (ImmutableSet)StreamSupport.stream(docs.spliterator(), false).map(doc -> ((ObjectId)doc.get((Object)"_id", ObjectId.class)).toHexString()).collect(ImmutableSet.toImmutableSet());
    }

    public List<AuthzRoleDTO> findByIds(Collection<String> ids) {
        return this.asImmutableList(this.db.find(DBQuery.in((String)"_id", ids)));
    }

    public PaginatedList<AuthzRoleDTO> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
    }

    public PaginatedList<AuthzRoleDTO> findPaginatedByIds(SearchQuery searchQuery, int page, int perPage, String sortField, String order, Set<String> roleIds) {
        DBQuery.Query dbQuery = this.buildRoleIdsQuery(searchQuery, roleIds);
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
    }

    public PaginatedList<AuthzRoleDTO> findPaginatedByIdsWithFilter(SearchQuery searchQuery, Predicate<AuthzRoleDTO> filter, int page, int perPage, String sortField, String order, Set<String> roleIds) {
        DBQuery.Query dbQuery = this.buildRoleIdsQuery(searchQuery, roleIds);
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryFilterAndSort(dbQuery, filter, sortBuilder, page, perPage);
    }

    @Override
    public int delete(String id) {
        Optional role = this.get(id);
        int delete = super.delete(id);
        if (delete > 0) {
            role.ifPresent(r -> this.userService.dissociateAllUsersFromRole(r.toLegacyRole()));
        }
        return delete;
    }

    private DBQuery.Query buildRoleIdsQuery(SearchQuery searchQuery, Set<String> roleIds) {
        return DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"_id", roleIds), searchQuery.toDBQuery()});
    }
}

