/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.DBGrantService;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.rest.RestResourceWithOwnerCheck;
import org.graylog.security.shares.EntityShareRequest;
import org.graylog.security.shares.EntityShareResponse;
import org.graylog.security.shares.EntitySharesService;
import org.graylog.security.shares.GranteeSharesService;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/authz/shares")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="Authorization/Shares", description="Manage share permissions on entities")
@RequiresAuthentication
public class EntitySharesResource
extends RestResourceWithOwnerCheck {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySharesResource.class);
    private final GRNRegistry grnRegistry;
    private final DBGrantService grantService;
    private final UserService userService;
    private final GranteeSharesService granteeSharesService;
    private final EntitySharesService entitySharesService;

    @Inject
    public EntitySharesResource(GRNRegistry grnRegistry, DBGrantService grantService, UserService userService, GranteeSharesService granteeSharesService, EntitySharesService entitySharesService) {
        this.grnRegistry = grnRegistry;
        this.grantService = grantService;
        this.userService = userService;
        this.granteeSharesService = granteeSharesService;
        this.entitySharesService = entitySharesService;
    }

    @GET
    @ApiOperation(value="Return shares for a user")
    @Path(value="user/{userId}")
    public PaginatedResponse<EntityDescriptor> get(@ApiParam(name="pagination parameters") @BeanParam PaginationParameters paginationParameters, @ApiParam(name="userId", required=true) @PathParam(value="userId") @NotBlank String userId, @ApiParam(name="capability") @QueryParam(value="capability") @DefaultValue(value="") String capabilityFilter, @ApiParam(name="entity_type") @QueryParam(value="entity_type") @DefaultValue(value="") String entityTypeFilter) {
        User user = this.userService.loadById(userId);
        if (user == null) {
            throw new NotFoundException("Couldn't find user <" + userId + ">");
        }
        if (!this.isPermitted("users:edit", user.getName())) {
            throw new ForbiddenException("Couldn't access user <" + userId + ">");
        }
        GranteeSharesService.SharesResponse response = this.granteeSharesService.getPaginatedSharesFor(this.grnRegistry.ofUser(user), paginationParameters, capabilityFilter, entityTypeFilter);
        return PaginatedResponse.create("entities", response.paginatedEntities(), Collections.singletonMap("grantee_capabilities", response.capabilities()));
    }

    @POST
    @ApiOperation(value="Prepare shares for an entity or collection")
    @Path(value="entities/{entityGRN}/prepare")
    @NoAuditEvent(value="This does not change any data")
    public EntityShareResponse prepareShare(@ApiParam(name="entityGRN", required=true) @PathParam(value="entityGRN") @NotBlank String entityGRN, @ApiParam(name="JSON Body", required=true) @NotNull @Valid EntityShareRequest request) {
        GRN grn = this.grnRegistry.parse(entityGRN);
        this.checkOwnership(grn);
        return this.entitySharesService.prepareShare(grn, request, this.getCurrentUser(), this.getSubject());
    }

    @POST
    @ApiOperation(value="Create / update shares for an entity or collection")
    @Path(value="entities/{entityGRN}")
    @NoAuditEvent(value="Audit events are created within EntitySharesService")
    public Response updateEntityShares(@ApiParam(name="entityGRN", required=true) @PathParam(value="entityGRN") @NotBlank String entityGRN, @ApiParam(name="JSON Body", required=true) @NotNull @Valid EntityShareRequest request) {
        GRN entity = this.grnRegistry.parse(entityGRN);
        this.checkOwnership(entity);
        EntityShareResponse entityShareResponse = this.entitySharesService.updateEntityShares(entity, request, Objects.requireNonNull(this.getCurrentUser()));
        if (entityShareResponse.validationResult().failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entityShareResponse).build();
        }
        return Response.ok((Object)entityShareResponse).build();
    }
}

