/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.GranteeAuthorizer;
import org.graylog.security.shares.Grantee;
import org.graylog.security.shares.GranteeService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.UserAndTeamsConfig;

public class DefaultGranteeService
implements GranteeService {
    protected final UserService userService;
    protected final GRNRegistry grnRegistry;
    protected final GranteeAuthorizer.Factory granteeAuthorizerFactory;
    protected final ClusterConfigService clusterConfigService;

    @Inject
    public DefaultGranteeService(UserService userService, GRNRegistry grnRegistry, GranteeAuthorizer.Factory granteeAuthorizerFactory, ClusterConfigService clusterConfigService) {
        this.userService = userService;
        this.grnRegistry = grnRegistry;
        this.granteeAuthorizerFactory = granteeAuthorizerFactory;
        this.clusterConfigService = clusterConfigService;
    }

    public ImmutableSet<Grantee> getAvailableGrantees(User sharingUser) {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll(this.getAvailableUserGrantees(sharingUser));
        this.getGlobalGrantee().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public Set<GRN> getGranteeAliases(GRN grantee) {
        return Collections.singleton(grantee);
    }

    @Override
    public Set<User> getVisibleUsers(User requestingUser) {
        GranteeAuthorizer userAuthorizer = this.granteeAuthorizerFactory.create(requestingUser);
        if (userAuthorizer.isPermitted("users:list")) {
            return (Set)this.userService.loadAll().stream().collect(ImmutableSet.toImmutableSet());
        }
        return (Set)this.userService.loadAll().stream().filter(u -> userAuthorizer.isPermitted("users:read", u.getName())).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<Grantee> getAvailableUserGrantees(User sharingUser) {
        UserAndTeamsConfig config = this.clusterConfigService.getOrDefault(UserAndTeamsConfig.class, UserAndTeamsConfig.DEFAULT_VALUES);
        if (!config.sharingWithUsers()) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)this.getVisibleUsers(sharingUser).stream().filter(user -> !sharingUser.getId().equals(user.getId())).map(user -> Grantee.createUser(this.grnRegistry.ofUser((User)user), user.getFullName())).collect(ImmutableSet.toImmutableSet());
    }

    private Optional<Grantee> getGlobalGrantee() {
        UserAndTeamsConfig config = this.clusterConfigService.getOrDefault(UserAndTeamsConfig.class, UserAndTeamsConfig.DEFAULT_VALUES);
        if (config.sharingWithEveryone()) {
            return Optional.of(Grantee.createGlobal());
        }
        return Optional.empty();
    }
}

