/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graylog.grn.GRN;
import org.graylog.security.Capability;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.shares.AutoValue_EntityShareResponse;
import org.graylog.security.shares.AutoValue_EntityShareResponse_ActiveShare;
import org.graylog.security.shares.AutoValue_EntityShareResponse_AvailableCapability;
import org.graylog.security.shares.Grantee;
import org.graylog2.plugin.rest.ValidationResult;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EntityShareResponse {
    @JsonProperty(value="entity")
    public abstract String entity();

    @JsonProperty(value="sharing_user")
    public abstract GRN sharingUser();

    @JsonProperty(value="available_grantees")
    public abstract ImmutableSet<Grantee> availableGrantees();

    @JsonProperty(value="available_capabilities")
    public abstract ImmutableSet<AvailableCapability> availableCapabilities();

    @JsonProperty(value="active_shares")
    public abstract ImmutableSet<ActiveShare> activeShares();

    @JsonProperty(value="selected_grantee_capabilities")
    public abstract ImmutableMap<GRN, Capability> selectedGranteeCapabilities();

    @JsonProperty(value="missing_permissions_on_dependencies")
    public abstract ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies();

    @JsonProperty(value="validation_result")
    public abstract ValidationResult validationResult();

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue
    public static abstract class ActiveShare {
        @JsonProperty(value="grant")
        public abstract String grant();

        @JsonProperty(value="grantee")
        public abstract GRN grantee();

        @JsonProperty(value="capability")
        public abstract Capability capability();

        @JsonCreator
        public static ActiveShare create(@JsonProperty(value="grant") String grant, @JsonProperty(value="grantee") GRN grantee, @JsonProperty(value="capability") Capability capability) {
            return new AutoValue_EntityShareResponse_ActiveShare(grant, grantee, capability);
        }
    }

    @AutoValue
    public static abstract class AvailableCapability {
        @JsonProperty(value="id")
        public abstract String id();

        @JsonProperty(value="title")
        public abstract String title();

        @JsonCreator
        public static AvailableCapability create(@JsonProperty(value="id") String id, @JsonProperty(value="title") String title) {
            return new AutoValue_EntityShareResponse_AvailableCapability(id, title);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EntityShareResponse.Builder().activeShares(Collections.emptySet()).selectedGranteeCapabilities(Collections.emptyMap()).missingPermissionsOnDependencies(Collections.emptyMap()).validationResult(new ValidationResult());
        }

        @JsonProperty(value="entity")
        public abstract Builder entity(String var1);

        @JsonProperty(value="sharing_user")
        public abstract Builder sharingUser(GRN var1);

        @JsonProperty(value="available_grantees")
        public abstract Builder availableGrantees(Set<Grantee> var1);

        @JsonProperty(value="available_capabilities")
        public abstract Builder availableCapabilities(Set<AvailableCapability> var1);

        @JsonProperty(value="active_shares")
        public abstract Builder activeShares(Set<ActiveShare> var1);

        @JsonProperty(value="selected_grantee_capabilities")
        public abstract Builder selectedGranteeCapabilities(Map<GRN, Capability> var1);

        @JsonProperty(value="missing_permissions_on_dependencies")
        public abstract Builder missingPermissionsOnDependencies(Map<GRN, Collection<EntityDescriptor>> var1);

        @JsonProperty(value="validation_result")
        public abstract Builder validationResult(ValidationResult var1);

        public abstract EntityShareResponse build();
    }
}

