/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SortedPathSetConverter
implements Converter<SortedSet<Path>> {
    protected static final String SEPARATOR = ",";

    public SortedSet<Path> convertFrom(String value) {
        if (value == null) {
            throw new ParameterException("Path list must not be null.");
        }
        return Arrays.stream(value.split(SEPARATOR)).map(StringUtils::trimToNull).filter(Objects::nonNull).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toCollection(this.sortedPathSupplier()));
    }

    public String convertTo(SortedSet<Path> value) {
        if (value == null) {
            throw new ParameterException("String list of Paths must not be null.");
        }
        return value.stream().map(Path::toString).collect(Collectors.joining(SEPARATOR));
    }

    private Supplier<TreeSet<Path>> sortedPathSupplier() {
        return () -> new TreeSet<Path>(Comparator.comparing(Path::toString));
    }
}

