/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.validators;

import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;

public class RotationStrategyValidator
implements Validator<Set<String>> {
    Set<String> VALID_STRATEGIES = Sets.newHashSet((Object[])new String[]{"count", "size", "time"});

    public void validate(String parameter, Set<String> value) throws ValidationException {
        if (value == null || value.isEmpty()) {
            throw new ValidationException("Parameter " + parameter + " should be non-empty list");
        }
        if (!value.stream().filter(s -> !this.VALID_STRATEGIES.contains(s)).collect(Collectors.toSet()).isEmpty()) {
            throw new ValidationException("Parameter " + parameter + " contains invalid values: " + value);
        }
    }
}

