/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.contentpacks.model.entities.TypedEntity;

public class ValueReferenceTypeIdResolver
extends TypeIdResolverBase {
    private final Map<String, JavaType> subtypes;

    protected ValueReferenceTypeIdResolver(JavaType baseType, TypeFactory typeFactory, Collection<NamedType> subtypes) {
        super(baseType, typeFactory);
        this.subtypes = subtypes.stream().collect(Collectors.toMap(NamedType::getName, v -> typeFactory.constructSimpleType(v.getType(), new JavaType[0])));
    }

    public String idFromValue(Object value) {
        if (value instanceof TypedEntity) {
            TypedEntity typedEntity = (TypedEntity)value;
            return typedEntity.typeString();
        }
        return null;
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return null;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        return this.subtypes.get(id);
    }
}

