/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.contentpacks.model.entities.references.ValueType;

public class ValueTypeDeserializer
extends StdDeserializer<ValueType> {
    public ValueTypeDeserializer() {
        super(ValueType.class);
    }

    public ValueType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentTokenId() == 6) {
            String str = StringUtils.upperCase((String)p.getText(), (Locale)Locale.ROOT);
            try {
                return ValueType.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                throw ctxt.weirdStringException(str, ValueType.class, e.getMessage());
            }
        }
        throw ctxt.wrongTokenException(p, JsonToken.VALUE_STRING, "expected String " + Arrays.toString((Object[])ValueType.values()));
    }
}

