/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.constraints;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.vdurmont.semver4j.Requirement;
import org.graylog2.contentpacks.model.constraints.AutoValue_GraylogVersionConstraint;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.plugin.Version;

@JsonDeserialize(builder=AutoValue_GraylogVersionConstraint.Builder.class)
@AutoValue
public abstract class GraylogVersionConstraint
implements Constraint {
    public static final String TYPE_NAME = "server-version";
    private static final String FIELD_GRAYLOG_VERSION = "version";

    @JsonProperty(value="version")
    public abstract Requirement version();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_GraylogVersionConstraint.Builder();
    }

    public static GraylogVersionConstraint of(Version version) {
        String versionString = version.toString().replace("-SNAPSHOT", "");
        Requirement requirement = Requirement.buildNPM((String)(">=" + versionString));
        return GraylogVersionConstraint.builder().version(requirement).build();
    }

    public static GraylogVersionConstraint currentGraylogVersion() {
        return GraylogVersionConstraint.of(Version.CURRENT_CLASSPATH);
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements Constraint.ConstraintBuilder<Builder> {
        @JsonProperty(value="version")
        public abstract Builder version(Requirement var1);

        @JsonIgnore
        public Builder version(String versionExpression) {
            Requirement requirement = Requirement.buildNPM((String)versionExpression);
            return this.version(requirement);
        }

        abstract GraylogVersionConstraint autoBuild();

        public GraylogVersionConstraint build() {
            this.type(GraylogVersionConstraint.TYPE_NAME);
            return this.autoBuild();
        }
    }
}

