/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.contentpacks.model.entities.AutoValue_ViewEntity;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.graylog2.contentpacks.model.entities.ViewEntity;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;

abstract class $AutoValue_ViewEntity
extends ViewEntity {
    private final ViewEntity.Type type;
    @NotBlank
    private final ValueReference title;
    private final ValueReference summary;
    private final ValueReference description;
    private final SearchEntity search;
    private final ImmutableSet<String> properties;
    private final Map<String, PluginMetadataSummary> requires;
    private final Map<String, ViewStateEntity> state;
    private final Optional<String> owner;
    private final DateTime createdAt;

    $AutoValue_ViewEntity(ViewEntity.Type type, @NotBlank ValueReference title, ValueReference summary, ValueReference description, SearchEntity search, ImmutableSet<String> properties, Map<String, PluginMetadataSummary> requires, Map<String, ViewStateEntity> state, Optional<String> owner, DateTime createdAt) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        if (summary == null) {
            throw new NullPointerException("Null summary");
        }
        this.summary = summary;
        if (description == null) {
            throw new NullPointerException("Null description");
        }
        this.description = description;
        if (search == null) {
            throw new NullPointerException("Null search");
        }
        this.search = search;
        if (properties == null) {
            throw new NullPointerException("Null properties");
        }
        this.properties = properties;
        if (requires == null) {
            throw new NullPointerException("Null requires");
        }
        this.requires = requires;
        if (state == null) {
            throw new NullPointerException("Null state");
        }
        this.state = state;
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        if (createdAt == null) {
            throw new NullPointerException("Null createdAt");
        }
        this.createdAt = createdAt;
    }

    @Override
    @JsonProperty(value="type")
    public ViewEntity.Type type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public ValueReference title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="summary")
    public ValueReference summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="description")
    public ValueReference description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="search")
    public SearchEntity search() {
        return this.search;
    }

    @Override
    @JsonProperty(value="properties")
    public ImmutableSet<String> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="requires")
    public Map<String, PluginMetadataSummary> requires() {
        return this.requires;
    }

    @Override
    @JsonProperty(value="state")
    public Map<String, ViewStateEntity> state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="owner")
    public Optional<String> owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="created_at")
    public DateTime createdAt() {
        return this.createdAt;
    }

    public String toString() {
        return "ViewEntity{type=" + (Object)((Object)this.type) + ", title=" + this.title + ", summary=" + this.summary + ", description=" + this.description + ", search=" + this.search + ", properties=" + this.properties + ", requires=" + this.requires + ", state=" + this.state + ", owner=" + this.owner + ", createdAt=" + this.createdAt + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ViewEntity) {
            ViewEntity that = (ViewEntity)o;
            return this.type.equals((Object)that.type()) && this.title.equals(that.title()) && this.summary.equals(that.summary()) && this.description.equals(that.description()) && this.search.equals(that.search()) && this.properties.equals(that.properties()) && this.requires.equals(that.requires()) && this.state.equals(that.state()) && this.owner.equals(that.owner()) && this.createdAt.equals((Object)that.createdAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.summary.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.search.hashCode();
        h$ *= 1000003;
        h$ ^= this.properties.hashCode();
        h$ *= 1000003;
        h$ ^= this.requires.hashCode();
        h$ *= 1000003;
        h$ ^= this.state.hashCode();
        h$ *= 1000003;
        h$ ^= this.owner.hashCode();
        h$ *= 1000003;
        return h$ ^= this.createdAt.hashCode();
    }

    @Override
    public ViewEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends ViewEntity.Builder {
        private ViewEntity.Type type;
        @NotBlank
        private ValueReference title;
        private ValueReference summary;
        private ValueReference description;
        private SearchEntity search;
        private ImmutableSet.Builder<String> propertiesBuilder$;
        private ImmutableSet<String> properties;
        private Map<String, PluginMetadataSummary> requires;
        private Map<String, ViewStateEntity> state;
        private Optional<String> owner = Optional.empty();
        private DateTime createdAt;

        Builder() {
        }

        private Builder(ViewEntity source) {
            this.type = source.type();
            this.title = source.title();
            this.summary = source.summary();
            this.description = source.description();
            this.search = source.search();
            this.properties = source.properties();
            this.requires = source.requires();
            this.state = source.state();
            this.owner = source.owner();
            this.createdAt = source.createdAt();
        }

        @Override
        public ViewEntity.Builder type(ViewEntity.Type type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public ViewEntity.Builder title(ValueReference title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public ViewEntity.Builder summary(ValueReference summary) {
            if (summary == null) {
                throw new NullPointerException("Null summary");
            }
            this.summary = summary;
            return this;
        }

        @Override
        public ViewEntity.Builder description(ValueReference description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public ViewEntity.Builder search(SearchEntity search) {
            if (search == null) {
                throw new NullPointerException("Null search");
            }
            this.search = search;
            return this;
        }

        @Override
        ImmutableSet.Builder<String> propertiesBuilder() {
            if (this.propertiesBuilder$ == null) {
                if (this.properties == null) {
                    this.propertiesBuilder$ = ImmutableSet.builder();
                } else {
                    this.propertiesBuilder$ = ImmutableSet.builder();
                    this.propertiesBuilder$.addAll(this.properties);
                    this.properties = null;
                }
            }
            return this.propertiesBuilder$;
        }

        @Override
        public ViewEntity.Builder requires(Map<String, PluginMetadataSummary> requires) {
            if (requires == null) {
                throw new NullPointerException("Null requires");
            }
            this.requires = requires;
            return this;
        }

        @Override
        public ViewEntity.Builder state(Map<String, ViewStateEntity> state) {
            if (state == null) {
                throw new NullPointerException("Null state");
            }
            this.state = state;
            return this;
        }

        @Override
        public ViewEntity.Builder owner(@Nullable String owner) {
            this.owner = Optional.ofNullable(owner);
            return this;
        }

        @Override
        public ViewEntity.Builder createdAt(DateTime createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ViewEntity build() {
            if (this.propertiesBuilder$ != null) {
                this.properties = this.propertiesBuilder$.build();
            } else if (this.properties == null) {
                this.properties = ImmutableSet.of();
            }
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.summary == null) {
                missing = missing + " summary";
            }
            if (this.description == null) {
                missing = missing + " description";
            }
            if (this.search == null) {
                missing = missing + " search";
            }
            if (this.requires == null) {
                missing = missing + " requires";
            }
            if (this.state == null) {
                missing = missing + " state";
            }
            if (this.createdAt == null) {
                missing = missing + " createdAt";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ViewEntity(this.type, this.title, this.summary, this.description, this.search, this.properties, this.requires, this.state, this.owner, this.createdAt);
        }
    }
}

