/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.graylog2.contentpacks.model.entities.AutoValue_AbsoluteRangeEntity;
import org.graylog2.contentpacks.model.entities.ModelTypeEntity;
import org.graylog2.contentpacks.model.entities.TimeRangeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.format.ISODateTimeFormat;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_AbsoluteRangeEntity.Builder.class)
@AutoValue
public abstract class AbsoluteRangeEntity
extends TimeRangeEntity {
    static final String TYPE = "absolute";
    private static final String FIELD_FROM = "from";
    private static final String FIELD_TO = "to";

    @JsonProperty(value="from")
    public abstract ValueReference from();

    @JsonProperty(value="to")
    public abstract ValueReference to();

    public static AbsoluteRangeEntity of(AbsoluteRange absoluteRange) {
        String from = absoluteRange.from().toString(ISODateTimeFormat.dateTime());
        String to = absoluteRange.to().toString(ISODateTimeFormat.dateTime());
        return AbsoluteRangeEntity.builder().from(ValueReference.of(from)).to(ValueReference.of(to)).build();
    }

    static Builder builder() {
        return new AutoValue_AbsoluteRangeEntity.Builder();
    }

    @Override
    public final TimeRange convert(Map<String, ValueReference> parameters) {
        String from = this.from().asString(parameters);
        String to = this.to().asString(parameters);
        try {
            return AbsoluteRange.create(from, to);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException("Invalid timerange.", e);
        }
    }

    @AutoValue.Builder
    static abstract class Builder
    implements TimeRangeEntity.TimeRangeBuilder<Builder> {
        Builder() {
        }

        @JsonProperty(value="from")
        abstract Builder from(ValueReference var1);

        @JsonProperty(value="to")
        abstract Builder to(ValueReference var1);

        abstract AbsoluteRangeEntity autoBuild();

        AbsoluteRangeEntity build() {
            this.type(ModelTypeEntity.of(AbsoluteRangeEntity.TYPE));
            return this.autoBuild();
        }
    }
}

