/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.streams.Stream;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Fallback.class)
@JsonAutoDetect
public interface SearchTypeEntity
extends NativeEntityConverter<SearchType> {
    public static final String TYPE_FIELD = "type";

    @JsonProperty(value="type")
    public String type();

    @JsonProperty(value="id")
    public String id();

    @JsonProperty
    public Optional<String> name();

    @Nullable
    @JsonProperty(value="filter")
    public Filter filter();

    @JsonProperty
    public Optional<DerivedTimeRange> timerange();

    @JsonProperty
    public Optional<BackendQuery> query();

    @JsonProperty
    public Set<String> streams();

    public Builder toGenericBuilder();

    default public Set<String> effectiveStreams() {
        return this.streams();
    }

    default public Set<String> mappedStreams(Map<EntityDescriptor, Object> nativeEntities) {
        return this.streams().stream().map(s -> EntityDescriptor.create(s, ModelTypes.STREAM_V1)).map(nativeEntities::get).map(object -> {
            if (object == null) {
                throw new ContentPackException("Missing Stream for event definition");
            }
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                return stream.getId();
            }
            throw new ContentPackException("Invalid type for stream Stream for event definition: " + object.getClass());
        }).collect(Collectors.toSet());
    }

    @JsonAutoDetect
    public static class Fallback
    implements SearchTypeEntity {
        @JsonProperty
        private String type;
        @JsonProperty
        private String id;
        @JsonProperty
        private Optional<String> name;
        private Map<String, Object> props = Maps.newHashMap();
        @Nullable
        @JsonProperty
        private Filter filter;
        @Nullable
        @JsonProperty
        private DerivedTimeRange timeRange;
        @Nullable
        @JsonProperty
        private BackendQuery query;
        @JsonProperty
        private Set<String> streams;

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<String> name() {
            return this.name;
        }

        @Override
        public Filter filter() {
            return this.filter;
        }

        @Override
        public Optional<DerivedTimeRange> timerange() {
            return Optional.ofNullable(this.timeRange);
        }

        @Override
        public Optional<BackendQuery> query() {
            return Optional.ofNullable(this.query);
        }

        @Override
        public Set<String> streams() {
            return this.streams == null ? Collections.emptySet() : this.streams;
        }

        @Override
        public Builder toGenericBuilder() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fallback fallback = (Fallback)o;
            return Objects.equals(this.type, fallback.type) && Objects.equals(this.id, fallback.id) && Objects.equals(this.props, fallback.props);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.props);
        }

        @Override
        public SearchType toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
            return null;
        }
    }

    public static interface Builder {
        public Builder streams(Set<String> var1);

        public SearchTypeEntity build();
    }
}

