/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.zafarkhaja.semver.Version;
import javax.annotation.Nonnull;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.EventsIndexMapping6;
import org.graylog2.indexer.EventsIndexMapping7;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.IndexTemplateProvider;
import org.graylog2.indexer.indexset.IndexSetConfig;

public class EventIndexTemplateProvider
implements IndexTemplateProvider {
    public static final String EVENT_TEMPLATE_TYPE = "events";

    @Override
    public IndexMappingTemplate create(@Nonnull Version elasticsearchVersion, @Nonnull IndexSetConfig indexSetConfig) {
        if (elasticsearchVersion.satisfies("^5.0.0 | ^6.0.0")) {
            return new EventsIndexMapping6();
        }
        if (elasticsearchVersion.satisfies("^7.0.0")) {
            return new EventsIndexMapping7();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }
}

