/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.system.NodeId;

public class SizeBasedRotationStrategy
extends AbstractRotationStrategy {
    public static final String NAME = "size";
    private final Indices indices;

    @Inject
    public SizeBasedRotationStrategy(Indices indices, NodeId nodeId, AuditEventSender auditEventSender, ElasticsearchConfiguration elasticsearchConfiguration) {
        super(auditEventSender, nodeId, elasticsearchConfiguration);
        this.indices = indices;
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return SizeBasedRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return SizeBasedRotationStrategyConfig.createDefault();
    }

    @Override
    @Nullable
    protected AbstractRotationStrategy.Result shouldRotate(final String index, IndexSet indexSet) {
        if (!(indexSet.getConfig().rotationStrategy() instanceof SizeBasedRotationStrategyConfig)) {
            throw new IllegalStateException("Invalid rotation strategy config <" + indexSet.getConfig().rotationStrategy().getClass().getCanonicalName() + "> for index set <" + indexSet.getConfig().id() + ">");
        }
        final SizeBasedRotationStrategyConfig config = (SizeBasedRotationStrategyConfig)indexSet.getConfig().rotationStrategy();
        Optional<Long> storeSizeInBytes = this.indices.getStoreSizeInBytes(index);
        if (!storeSizeInBytes.isPresent()) {
            return null;
        }
        final long sizeInBytes = storeSizeInBytes.get();
        final boolean shouldRotate = sizeInBytes > config.maxSize();
        return new AbstractRotationStrategy.Result(){
            public final MessageFormat ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, exceeding the maximum of {2} bytes. Rotating index.", Locale.ENGLISH);
            public final MessageFormat NOT_ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, below the maximum of {2} bytes. Not doing anything.", Locale.ENGLISH);

            @Override
            public String getDescription() {
                MessageFormat format = this.shouldRotate() ? this.ROTATE : this.NOT_ROTATE;
                return format.format(new Object[]{index, sizeInBytes, config.maxSize()});
            }

            @Override
            public boolean shouldRotate() {
                return shouldRotate;
            }
        };
    }

    @Override
    public String getStrategyName() {
        return NAME;
    }
}

