/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import org.graylog2.inputs.transports.netty.SenderEnvelope;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvelopeMessageAggregationHandler
extends SimpleChannelInboundHandler<AddressedEnvelope<ByteBuf, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(EnvelopeMessageAggregationHandler.class);
    private final CodecAggregator aggregator;
    private final Timer aggregationTimer;
    private final Meter invalidChunksMeter;

    public EnvelopeMessageAggregationHandler(CodecAggregator aggregator, MetricRegistry metricRegistry) {
        this.aggregator = aggregator;
        this.aggregationTimer = metricRegistry.timer("aggregationTime");
        this.invalidChunksMeter = metricRegistry.meter("invalidMessages");
    }

    protected void channelRead0(ChannelHandlerContext ctx, AddressedEnvelope<ByteBuf, InetSocketAddress> envelope) throws Exception {
        CodecAggregator.Result result;
        try (Timer.Context ignored = this.aggregationTimer.time();){
            result = this.aggregator.addChunk((ByteBuf)envelope.content());
        }
        ByteBuf completeMessage = result.getMessage();
        if (completeMessage != null) {
            LOG.debug("Message aggregation completion, forwarding {}", (Object)completeMessage);
            ctx.fireChannelRead(SenderEnvelope.of(completeMessage, (InetSocketAddress)envelope.sender()));
        } else if (result.isValid()) {
            LOG.debug("More chunks necessary to complete this message");
        } else {
            this.invalidChunksMeter.mark();
            LOG.debug("Message chunk was not valid and discarded.");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        LOG.error("Caught exception while decoding type of GELF packet: {}", (Object)e.getMessage());
        this.invalidChunksMeter.mark();
    }
}

