/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.IOException;

public class SemverDeserializer
extends StdDeserializer<Semver> {
    private final Semver.SemverType semverType;

    public SemverDeserializer() {
        this(Semver.SemverType.NPM);
    }

    public SemverDeserializer(Semver.SemverType semverType) {
        super(Semver.class);
        this.semverType = semverType;
    }

    public Semver deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: 
            case 7: {
                String str = p.getText().trim();
                try {
                    return this.buildSemver(str);
                }
                catch (SemverException e) {
                    ctxt.reportMappingException(e.getMessage(), new Object[0]);
                }
            }
        }
        throw ctxt.wrongTokenException(p, JsonToken.VALUE_STRING, "expected String or Number");
    }

    private Semver buildSemver(String s) {
        return new Semver(s, this.semverType);
    }
}

