/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jersey;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.graylog2.Configuration;
import org.graylog2.shared.rest.HideOnCloud;

@Provider
public class PrefixAddingModelProcessor
implements ModelProcessor {
    private final Map<String, String> packagePrefixes;
    private final Configuration configuration;

    public PrefixAddingModelProcessor(Map<String, String> packagePrefixes, Configuration configuration) {
        this.packagePrefixes = ImmutableMap.copyOf(packagePrefixes);
        this.configuration = configuration;
    }

    public ResourceModel processResourceModel(ResourceModel model, javax.ws.rs.core.Configuration config) {
        ResourceModel.Builder resourceModelBuilder = new ResourceModel.Builder(false);
        for (Resource resource : model.getResources()) {
            Class handlerClass;
            HideOnCloud hideOnCloud;
            Iterator iterator = resource.getHandlerClasses().iterator();
            while (iterator.hasNext() && ((hideOnCloud = (handlerClass = (Class)iterator.next()).getAnnotation(HideOnCloud.class)) == null || !this.configuration.isCloud())) {
                String packageName = handlerClass.getPackage().getName();
                Optional<String> packagePrefix = this.packagePrefixes.entrySet().stream().filter(entry -> packageName.startsWith((String)entry.getKey())).sorted((o1, o2) -> -((String)o1.getKey()).compareTo((String)o2.getKey())).map(Map.Entry::getValue).findFirst();
                if (packagePrefix.isPresent()) {
                    String prefixedPath = this.prefixPath(packagePrefix.get(), resource.getPath());
                    Resource newResource = Resource.builder((Resource)resource).path(prefixedPath).build();
                    resourceModelBuilder.addResource(newResource);
                    continue;
                }
                resourceModelBuilder.addResource(resource);
            }
        }
        return resourceModelBuilder.build();
    }

    private String prefixPath(String prefix, String path) {
        String sanitizedPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
        String sanitizedPath = path.startsWith("/") ? path.substring(1) : path;
        return sanitizedPrefix + sanitizedPath;
    }

    public ResourceModel processSubResource(ResourceModel model, javax.ws.rs.core.Configuration config) {
        return model;
    }
}

