/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.messageprocessors;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.failure.ProcessingFailureCause;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.messageq.MessageQueueAcknowledger;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFilterChainProcessor
implements MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFilterChainProcessor.class);
    private final List<MessageFilter> filterRegistry;
    private final MetricRegistry metricRegistry;
    private final MessageQueueAcknowledger messageQueueAcknowledger;
    private final ServerStatus serverStatus;
    private final Meter filteredOutMessages;

    @Inject
    public MessageFilterChainProcessor(MetricRegistry metricRegistry, Set<MessageFilter> filterRegistry, MessageQueueAcknowledger messageQueueAcknowledger, ServerStatus serverStatus) {
        this.metricRegistry = metricRegistry;
        this.messageQueueAcknowledger = messageQueueAcknowledger;
        this.serverStatus = serverStatus;
        this.filterRegistry = Ordering.from((Comparator)new Comparator<MessageFilter>(){

            @Override
            public int compare(MessageFilter filter1, MessageFilter filter2) {
                return ComparisonChain.start().compare(filter1.getPriority(), filter2.getPriority()).compare((Comparable)((Object)filter1.getName()), (Comparable)((Object)filter2.getName())).result();
            }
        }).immutableSortedCopy(filterRegistry);
        if (filterRegistry.size() == 0) {
            throw new RuntimeException("Empty filter registry!");
        }
        this.filteredOutMessages = metricRegistry.meter(MetricRegistry.name(ProcessBufferProcessor.class, (String[])new String[]{"filteredOutMessages"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Messages process(Messages messages) {
        for (MessageFilter filter : this.filterRegistry) {
            for (Message msg : messages) {
                String timerName = MetricRegistry.name(filter.getClass(), (String[])new String[]{"executionTime"});
                Timer timer = this.metricRegistry.timer(timerName);
                Timer.Context timerContext = timer.time();
                try {
                    LOG.debug("Applying filter [{}] on message <{}>.", (Object)filter.getName(), (Object)msg.getId());
                    if (!filter.filter(msg)) continue;
                    LOG.debug("Filter [{}] marked message <{}> to be discarded. Dropping message.", (Object)filter.getName(), (Object)msg.getId());
                    msg.setFilterOut(true);
                    this.filteredOutMessages.mark();
                    this.messageQueueAcknowledger.acknowledge(msg);
                }
                catch (Exception e) {
                    String shortError = String.format(Locale.US, "Could not apply filter [%s] on message <%s>", filter.getName(), msg.getId());
                    if (LOG.isDebugEnabled()) {
                        LOG.error("{}:", (Object)shortError, (Object)e);
                    } else {
                        LOG.error("{}:\n{}", (Object)shortError, (Object)ExceptionUtils.getShortenedStackTrace(e));
                    }
                    msg.addProcessingError(new Message.ProcessingError(ProcessingFailureCause.MessageFilterException, shortError, ExceptionUtils.getRootCauseMessage(e)));
                }
                finally {
                    long elapsedNanos = timerContext.stop();
                    msg.recordTiming(this.serverStatus, timerName, elapsedNanos);
                }
            }
        }
        return messages;
    }

    @VisibleForTesting
    protected List<MessageFilter> getFilterRegistry() {
        return this.filterRegistry;
    }

    public static class Descriptor
    implements MessageProcessor.Descriptor {
        @Override
        public String name() {
            return "Message Filter Chain";
        }

        @Override
        public String className() {
            return MessageFilterChainProcessor.class.getCanonicalName();
        }
    }
}

