/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20200803120800_GrantsMigrations;

import java.util.Optional;
import javax.inject.Named;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewOwnerShipToGrantsMigration {
    private static final Logger LOG = LoggerFactory.getLogger(ViewOwnerShipToGrantsMigration.class);
    private final UserService userService;
    private final DBGrantService dbGrantService;
    private final String rootUsername;
    private final ViewService viewService;
    private final GRNRegistry grnRegistry;
    private static final Capability CAPABILITY = Capability.OWN;

    public ViewOwnerShipToGrantsMigration(UserService userService, DBGrantService dbGrantService, @Named(value="root_username") String rootUsername, ViewService viewService, GRNRegistry grnRegistry) {
        this.userService = userService;
        this.dbGrantService = dbGrantService;
        this.rootUsername = rootUsername;
        this.viewService = viewService;
        this.grnRegistry = grnRegistry;
    }

    public void upgrade() {
        this.viewService.streamAll().forEach(view -> {
            Optional<User> user = view.owner().map(this.userService::load);
            if (user.isPresent() && !user.get().isLocalAdmin()) {
                GRNType grnType = ViewDTO.Type.DASHBOARD.equals((Object)view.type()) ? GRNTypes.DASHBOARD : GRNTypes.SEARCH;
                GRN target = grnType.toGRN(view.id());
                this.ensureGrant(user.get(), target);
            }
        });
    }

    private void ensureGrant(User user, GRN target) {
        GRN grantee = this.grnRegistry.ofUser(user);
        LOG.info("Registering user <{}/{}> ownership for <{}>", new Object[]{user.getName(), user.getId(), target});
        this.dbGrantService.ensure(grantee, CAPABILITY, target, this.rootUsername);
    }
}

