/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20200803120800_GrantsMigrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSharingToGrantsMigration {
    private static final Logger LOG = LoggerFactory.getLogger(ViewSharingToGrantsMigration.class);
    private static final Capability CAPABILITY = Capability.VIEW;
    private final DBGrantService grantService;
    private final MongoCollection<Document> collection;
    private GRNRegistry grnRegistry;
    private final UserService userService;
    private final RoleService roleService;
    private final String rootUsername;
    private final ViewService viewService;

    public ViewSharingToGrantsMigration(MongoConnection mongoConnection, DBGrantService grantService, UserService userService, RoleService roleService, @Named(value="root_username") String rootUsername, ViewService viewService, GRNRegistry grnRegistry) {
        this.grantService = grantService;
        this.userService = userService;
        this.roleService = roleService;
        this.rootUsername = rootUsername;
        this.viewService = viewService;
        this.collection = mongoConnection.getMongoDatabase().getCollection("view_sharings", Document.class);
        this.grnRegistry = grnRegistry;
    }

    public void upgrade() {
        block12: for (Document document : this.collection.find()) {
            LOG.debug("Migrate view sharing: {}", (Object)document);
            ObjectId sharingId = document.getObjectId((Object)"_id");
            String sharingType = (String)document.get((Object)"type", String.class);
            String viewId = (String)document.get((Object)"view_id", String.class);
            try {
                switch (sharingType) {
                    case "users": {
                        this.migrateUsers(viewId, (Collection)document.get((Object)"users", Collection.class));
                        break;
                    }
                    case "roles": {
                        this.migrateRoles(viewId, (Collection)document.get((Object)"roles", Collection.class));
                        break;
                    }
                    case "all_of_instance": {
                        this.migrateAllOfInstance(viewId);
                        break;
                    }
                    default: {
                        LOG.warn("Skipping unknown view sharing type: {}", (Object)sharingType);
                        continue block12;
                    }
                }
                this.deleteViewSharing(sharingId);
            }
            catch (Exception e) {
                LOG.error("Couldn't migrate view sharing: {}", (Object)document, (Object)e);
            }
        }
    }

    private void migrateUsers(String viewId, Collection<String> userNames) {
        Set users = userNames.stream().map(this.userService::load).filter(Objects::nonNull).collect(Collectors.toSet());
        GRN target = this.getTarget(viewId);
        LOG.info("Migrate users for view <{}> to grants: {}", (Object)target, users.stream().map(u -> u.getId() + "/" + u.getName()).collect(Collectors.toSet()));
        for (User user : users) {
            this.ensureGrant(user, target);
        }
    }

    private void migrateRoles(String viewId, Collection<String> roleNames) {
        GRN target = this.getTarget(viewId);
        LOG.info("Migrate roles for view <{}> to grants: {}", (Object)target, roleNames);
        Set roles = roleNames.stream().map(roleName -> {
            try {
                return Optional.of(this.roleService.load((String)roleName));
            }
            catch (NotFoundException e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        for (Role role : roles) {
            for (User user : this.userService.loadAllForRole(role)) {
                this.ensureGrant(user, target);
            }
        }
    }

    private void migrateAllOfInstance(String viewId) {
        GRN target = this.getTarget(viewId);
        LOG.info("Migrate all-of-instance for view <{}> to grants", (Object)target);
        this.ensureEveryoneGrant(target);
    }

    private void ensureEveryoneGrant(GRN target) {
        GRN grantee = GRNRegistry.GLOBAL_USER_GRN;
        if (!this.grantService.hasGrantFor(grantee, CAPABILITY, target)) {
            this.grantService.create(grantee, CAPABILITY, target, this.rootUsername);
        }
    }

    private void ensureGrant(User user, GRN target) {
        GRN grantee = this.grnRegistry.ofUser(user);
        this.grantService.ensure(grantee, CAPABILITY, target, this.rootUsername);
    }

    private GRN getTarget(String viewId) {
        ViewDTO view = this.viewService.get(viewId).orElseThrow(() -> new IllegalArgumentException("View <" + viewId + "> doesn't exist"));
        GRNType grnType = ViewDTO.Type.DASHBOARD.equals((Object)view.type()) ? GRNTypes.DASHBOARD : GRNTypes.SEARCH;
        return grnType.toGRN(viewId);
    }

    private void deleteViewSharing(ObjectId id) {
        LOG.debug("Removing obsolete view sharing document {}", (Object)id);
        this.collection.deleteOne(Filters.eq((String)"_id", (Object)id));
    }
}

